% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-models.R
\name{ssvs_bvar_algo}
\alias{ssvs_bvar_algo}
\title{Stochastic Search Variable Selection in VAR}
\description{
This page describes a stochastic search variable selection (SSVS) MCMC algorithm
in a VAR model.
}
\section{SSVS Prior}{

Consider the vectorized formulation \eqn{vec(Y_0) = (I_k \otimes X_0) vec(A) + vec(Z_0)}.
As the other Bayesian VAR model, this model handles coefficients \eqn{A} and variance matrix \eqn{\Sigma_e}.
To shrink \eqn{\Sigma_e^{-1}}, however, upper cholesky factor is used as the alternative \eqn{\Sigma_e^{-1} = \Psi \Psi^\intercal} in this context.
\subsection{Prior of coefficients}{

Each \eqn{vec(A) = \alpha = (\alpha_1, \ldots, \alpha_{k^2 p + k})} except constant-corresponding term is restricted by
\eqn{\gamma = (\gamma_1, \ldots, \gamma_{k^2 p})^\intercal}, which is dummy vector.
Then
\deqn{
  h_i = \begin{cases}
    \tau_{0i} & \text{if } \gamma_i = 0 \\
    \tau_{1i} & \text{if } \gamma_i = 1
  \end{cases}
}
with small \eqn{\tau_{0j}} and large \eqn{\tau_{1j}}.
In turn, \eqn{D = diag(h_1, \ldots, h_{k^2 p})}.

Let \eqn{\alpha_{coef}} be the restricted coefficients vector
and let \eqn{\alpha_{non}} be the not-restricted coefficients vector, i.e. vectorized constant term.
Each term has its own prior.
\deqn{
  \alpha_{coef} \mid \gamma \sim N(0_{k^2 p}, DD),
  \quad
  \alpha_{non} \sim N(0_k, c I_k)
}
If \eqn{c} is large, then prior influence to \eqn{\alpha_{non}} decreases.
By combining each term in appropriate order,
\deqn{\alpha \mid \gamma \sim N(0_{k^2 p + k}, M)}
is acquired by
\deqn{
  M_0 = I_{k p + 1} \otimes \begin{bmatrix}
    DD & 0_{k^2 p} \\
    0_{k^2 p}^\intercal & c
  \end{bmatrix}
}
Sometimes nonzero prior mean \eqn{\alpha_0} is also considered.
}

\subsection{Prior of Coefficients Restrictions}{

It is natural that 0-1 \eqn{\gamma_{j}} has Bernoulli distribution.
\deqn{\gamma_j \sim Bernoulli(p_j)}
If there is no information, set \eqn{p_j = 0.5}.
}

\subsection{Prior of Cholesky Factor}{

Let \eqn{\Psi = [\psi_{ij}] \in \mathbb{R}^{k \times k}}.
Recall that \eqn{\Psi} is an upper triangular matrix such that \eqn{\Sigma_e^{-1} = \Psi \Psi^\intercal}.

To define the prior distribution, George et al. (2008) divide the matrix in two parts
\itemize{
\item Diagnonal element: \eqn{\psi = (\psi_{11}, \ldots, \psi_{kk})^\intercal}
\item Off-diagonal element: \eqn{\eta_j = (\psi_{1j}, \ldots, \psi_{j-1, j})^\intercal, j = 2, \ldots, k}
}
}

\subsection{Prior of off-diagonal element}{

To restrict cholesky factor, dummy vector \eqn{\omega_j = (\omega_{1j}, \ldots, \omega_{j - 1, j})^\intercal}
corresponding to off-diagonal elements are defined.
Then the matrix \eqn{D_j = diag(h_{1j}, \ldots, h_{j-1, j})} is defined by
\deqn{
  h_{ij} = \begin{cases}
    \kappa_{0ij} & \text{if } \omega_{ij} = 0 \\
    \kappa_{1ij} & \text{if } \omega_{ij} = 1
  \end{cases}
}
with small \eqn{\kappa_{0ij}} and large \eqn{\kappa_{1ij}}.
As coefficients vector, \eqn{\eta_j} has normal distribution
\deqn{\eta_j \mid \omega_j \sim N(0_{j - 1}, D_j D_j), j = 2, \ldots, k}
}

\subsection{Prior of off-diagonal element restrictions}{

As \eqn{\gamma_j}, \eqn{\omega_{ij}} has Bernoulli distribution.
\deqn{\omega_{ij} \sim Bernoulli(q_{ij})}
\eqn{q_{ij} = 0.5} is the most common choice.
}

\subsection{Prior of diagonal element}{

Since cholesky factor is positive definite, diagonal element of the matrix is given Gamma distribution.
\deqn{\psi_{jj}^2 \sim Gamma(shape = a_j, rate = b_j)}
}
}

\section{Gibbs Sampling}{

\subsection{Full Conditional}{

George et al. (2008) presents every full conditionals.
Let SSE matrix be \eqn{S(\hat{A}) = (Y_0 - X_0 \hat{A})^\intercal (Y_0 - X_0 \hat{A}) \in \mathbb{R}^{k \times k}},
let \eqn{S_j} be the upper-left j x j block matrix of \eqn{S(A)},
and let \eqn{s_j = (s_{1j}, \ldots, s_{j - 1, j})^\intercal} of \eqn{S(A)}.

For specified shape and rate of Gamma distribution \eqn{a_j} and \eqn{b_j},
\deqn{
  \psi_{jj}^2 \mid \alpha, \gamma, \omega, Y_0 \sim \gamma(a_i + n / 2, B_i)
}
where
\deqn{
  B_i = \begin{cases}
    b_1 + s_{11} / 2 & \text{if } i = 1 \\
    b_i + (s_{ii} - s_i^\intercal ( S_{i - 1} + (D_i R_i D_i)^(-1) )^(-1) s_i) & \text{if } i = 2, \ldots, k
  \end{cases}
}
, and \eqn{D_i = diag(h_{1j}, \ldots, h_{i - 1, i}) \in \mathbb{R}^{(j - 1) \times (j - 1)}}.

For every \eqn{j = 1, \ldots, k},
\deqn{
  \eta_j \mid \alpha, \gamma, \omega, \psi, Y_0 \sim N (\mu_j, \Delta_j)
}
where
\deqn{
  \mu_j = -\psi_{jj} (S_{j - 1} + (D_j R_j D_j)^{-1})^{-1} s_j \in \mathbb{R}^{j - 1},
  \Delta_j = (S_{j - 1} + (D_j R_j D_j)^{-1})^{-1} \in \mathbb{R}^{(j - 1) \times (j - 1)}
}

Consider restriction dummy vectors.
\deqn{
  \omega_{ij} \mid \eta_j, \psi_j, \alpha, \gamma, \omega_{j}^{(previous)} \sim Bernoulli(\frac{u_{ij1}}{u_{ij1} + u_{ij2}})
}
where
\deqn{
  u_{ij1} = \frac{1}{\kappa_{1ij}} \exp(- \frac{\psi_{ij}^2}{2 \kappa_{1ij}^2}) q_{ij},
  u_{ij2} = \frac{1}{\kappa_{0ij}} \exp(- \frac{\psi_{ij}^2}{2 \kappa_{0ij}^2}) (1 - q_{ij})
}
Also,
\deqn{
  \gamma_j \mid \alpha, \psi, \eta, \omega, Y_0 \sim Bernoulli(\frac{u_{i1}}{u_{j1} + u_{j2}})
}
where
\deqn{
  u_{j1} = \frac{1}{\tau_{1j}} \exp(- \frac{\alpha_j^2}{2 \tau_{1j}^2})p_i,
  u_{j2} = \frac{1}{\tau_{0j}} \exp(- \frac{\alpha_j^2}{2 \tau_{0j}^2})(1 - p_i)
}

In case of coefficients vector,
\deqn{\alpha \mid \gamma, \eta, \omega, \psi, Y_0 \sim N (\mu, \Delta)}
where
\deqn{
  \mu = (
'     (\Psi \Psi^\intercal) \otimes (X_0 X_0^\intercal) + M^{-1}
  )^{-1} (
'     ( (\Psi \Psi^\intercal) \otimes (X_0 X_0^\intercal) ) \hat{\alpha} + M^{-1} \alpha_0
  )
}
where \eqn{\alpha_0} is the prior mean for \eqn{\alpha \mid \gamma},
and \eqn{\hat{\alpha}} is MLE (equivalently, OLS).
\deqn{
  \Delta = ((\Psi \Psi^\intercal) \otimes (X_0 X_0^\intercal) + M^{-1})^{-1}
}
}

\subsection{Gibbs Sampling}{

Data: \eqn{X_0}, \eqn{Y_0}

Input:
\itemize{
\item VAR order p
\item MCMC iteration number
\item Weight of each slab: Bernoulli distribution parameters
\itemize{
\item \eqn{p_j}: of coefficients
\item \eqn{q_{ij}}: of cholesky factor
}
\item Gamma distribution parameters for cholesky factor diagonal elements \eqn{\psi_{jj}}
\itemize{
\item \eqn{a_j}: shape
\item \eqn{b_j}: rate
}
\item Correlation matrix of coefficient vector: \eqn{R = I_{k^2p}}
\item Correlation matrix to restrict cholesky factor (of \eqn{\eta_j}): \eqn{R_j = I_{j - 1}}
\item Tuning parameters for spike-and-slab sd semi-automatic approach
\itemize{
\item \eqn{c_0}: small value (0.1)
\item \eqn{c_1}: large value (10)
}
\item Constant to reduce prior influence on constant term: \eqn{c}
}

Algorithm:
\enumerate{
\item Initialize \eqn{\Psi}, \eqn{\omega}, \eqn{\alpha}, \eqn{\gamma}
\item Iterate
\enumerate{
\item Diagonal elements of cholesky factor: \eqn{\psi^{(t)} \mid \alpha^{(t - 1)}, \gamma^{(t - 1)}, \omega^{(t - 1)}, Y_0}
\item Off-diagonal elements of cholesky factor: \eqn{\eta^{(t)} \mid \psi^{(t)} \alpha^{(t - 1)}, \gamma^{(t - 1)}, \omega^{(t - 1)}, Y_0}
\item Dummy vector for cholesky factor: \eqn{\omega^{(t)} \mid \eta^{(t)}, \psi^{(t)} \alpha^{(t - 1)}, \gamma^{(t - 1)}, \omega^{(t - 1)}, Y_0}
\item Coefficient vector: \eqn{\alpha^{(t)} \mid \gamma^{(t - 1)}, \Sigma^{(t)}, \omega^{(t)}, Y_0}
\item Dummy vector for coefficient vector: \eqn{\gamma^{(t)} \mid \alpha^{(t)}, \psi^{(t)}, \eta^{(t)}, \omega^{(t)}, Y_0}
}
}

Output:
\itemize{
\item Parameter trace
\item Update results
\item OLS
}
}
}

\references{
George, E. I., Sun, D., & Ni, S. (2008). \emph{Bayesian stochastic search for VAR model restrictions. Journal of Econometrics}, 142(1), 553–580.

Koop, G., & Korobilis, D. (2009). \emph{Bayesian Multivariate Time Series Methods for Empirical Macroeconomics}. Foundations and Trends® in Econometrics, 3(4), 267–358.
}
\keyword{internal}
