% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vharlse.R, R/print-vharlse.R
\name{vhar_lm}
\alias{vhar_lm}
\alias{print.vharlse}
\alias{knit_print.vharlse}
\title{Fitting Vector Heterogeneous Autoregressive Model}
\usage{
vhar_lm(
  y,
  har = c(5, 22),
  include_mean = TRUE,
  method = c("nor", "chol", "qr")
)

\method{print}{vharlse}(x, digits = max(3L, getOption("digits") - 3L), ...)

knit_print.vharlse(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{har}{Numeric vector for weekly and monthly order. By default, \code{c(5, 22)}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{method}{Method to solve linear equation system.
(\code{"nor"}: normal equation (default), \code{"chol"}: Cholesky, and \code{"qr"}: HouseholderQR)}

\item{x}{\code{vharlse} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{vhar_lm()} returns an object named \code{vharlse} \link{class}.
It is a list with the following components:

\describe{
\item{coefficients}{Coefficient Matrix}
\item{fitted.values}{Fitted response values}
\item{residuals}{Residuals}
\item{covmat}{LS estimate for covariance matrix}
\item{df}{Numer of Coefficients: 3m + 1 or 3m}
\item{p}{3 (The number of terms. \code{vharlse} contains this element for usage in other functions.)}
\item{week}{Order for weekly term}
\item{month}{Order for monthly term}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - 22}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Process: VHAR}
\item{type}{include constant term (\code{"const"}) or not (\code{"none"})}
\item{HARtrans}{VHAR linear transformation matrix: \eqn{C_{HAR}}}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input}
}
It is also a \code{bvharmod} class.
}
\description{
This function fits VHAR using OLS method.
}
\details{
For VHAR model
\deqn{Y_{t} = \Phi^{(d)} Y_{t - 1} + \Phi^{(w)} Y_{t - 1}^{(w)} + \Phi^{(m)} Y_{t - 1}^{(m)} + \epsilon_t}
the function gives basic values.
}
\examples{
# Perform the function using etf_vix dataset
fit <- vhar_lm(y = etf_vix)
class(fit)
str(fit)

# Extract coef, fitted values, and residuals
coef(fit)
head(residuals(fit))
head(fitted(fit))
}
\references{
Baek, C. and Park, M. (2021). \emph{Sparse vector heterogeneous autoregressive modeling for realized volatility}. J. Korean Stat. Soc. 50, 495–510.

Bubák, V., Kočenda, E., & Žikeš, F. (2011). \emph{Volatility transmission in emerging European foreign exchange markets}. Journal of Banking & Finance, 35(11), 2829–2841.

Corsi, F. (2008). \emph{A Simple Approximate Long-Memory Model of Realized Volatility}. Journal of Financial Econometrics, 7(2), 174–196.
}
\seealso{
\itemize{
\item \code{\link[=coef.vharlse]{coef.vharlse()}}, \code{\link[=residuals.vharlse]{residuals.vharlse()}}, and \code{\link[=fitted.vharlse]{fitted.vharlse()}}
\item \code{\link[=summary.vharlse]{summary.vharlse()}} to summarize VHAR model
\item \code{\link[=predict.vharlse]{predict.vharlse()}} to forecast the VHAR process
}
}
