% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/klaR.R
\name{axe-rda}
\alias{axe-rda}
\alias{axe-klaR}
\alias{axe_call.rda}
\alias{axe_env.rda}
\title{Axing an rda.}
\usage{
\method{axe_call}{rda}(x, verbose = FALSE, ...)

\method{axe_env}{rda}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed rda object.
}
\description{
rda objects are created from the \pkg{klaR} package, leveraged to
carry out regularized discriminant analysis.
}
\examples{
\dontshow{if (rlang::is_installed("klaR")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(klaR)

fit_mod <- function() {
  boop <- runif(1e6)
  rda(
    y ~ x,
    data = data.frame(y = rep(letters[1:4], 1e4), x = rnorm(4e4)),
    gamma = 0.05,
    lambda = 0.2
  )
}

mod_fit <- fit_mod()
mod_res <- butcher(mod_fit)

weigh(mod_fit)
weigh(mod_res)

\dontshow{\}) # examplesIf}
}
