% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classbagg.R
\name{axe-classbagg}
\alias{axe-classbagg}
\alias{axe_call.classbagg}
\alias{axe_data.classbagg}
\alias{axe_env.classbagg}
\title{Axing a classbagg object.}
\usage{
\method{axe_call}{classbagg}(x, verbose = FALSE, ...)

\method{axe_data}{classbagg}(x, verbose = FALSE, ...)

\method{axe_env}{classbagg}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed classbagg object.
}
\description{
classbagg objects are created from the \pkg{ipred} package, which
leverages various resampling and bagging techniques to improve
predictive models.
}
\examples{
\dontshow{if (rlang::is_installed(c("ipred", "rpart", "MASS"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load libraries
library(ipred)
library(rpart)
library(MASS)

# Load data
data("GlaucomaM", package = "TH.data")

classbagg_fit <- bagging(Class ~ ., data = GlaucomaM, coob = TRUE)

out <- butcher(classbagg_fit, verbose = TRUE)

# Fit another model
data("DLBCL", package = "ipred")

mod <- bagging(Gene.Expression ~ MGEc.1 + MGEc.2 + MGEc.3 + MGEc.4 + IPI,
               data = DLBCL,
               coob = TRUE)

out <- butcher(mod, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
