% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_calc.R
\name{util_calc}
\alias{util_calc}
\title{Calculating quasi-linear iso-elastic utility}
\usage{
util_calc(z, n, elas, t1, t2, Tax, zstar)
}
\arguments{
\item{z}{Earnings}

\item{n}{Ability of person (earnings with zero tax)}

\item{elas}{elasticity of earnings w.r.t.  net-of-tax rate}

\item{t1}{Tax rate before notch/kink}

\item{t2}{Tax rate after notch/kink}

\item{Tax}{height of notch (zero for pure kink)}

\item{zstar}{place of notch/kink (critical earning point)}
}
\value{
The utility of earning sum z given other parameters.
}
\description{
\deqn{u(z,n,elas,t1,t2,Tax,zstar) =}
\deqn{z * (1 - t1) + [z > zstar] * ((z - zstar)
 * (t2 - t1) - Tax) - n / (1 + (1 / elas)) * (z / n)^(1 + (1 / elas))}
}
\examples{
util_calc(900, 950, 0.2, 0.1, 0.2, 100, 1000)

}

