% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ar1}
\alias{ar1}
\title{Univariate Gaussian model with AR(1) latent process}
\usage{
ar1(y, rho, sigma, mu, sd_y, beta, xreg = NULL)
}
\arguments{
\item{y}{Vector or a \code{\link{ts}} object of observations.}

\item{rho}{prior for autoregressive coefficient.}

\item{sigma}{Prior for the standard deviation of noise of the AR-process.}

\item{mu}{A fixed value or a prior for the intercept mu of the transition equation. Parameter is omitted if this is set to 0.}

\item{sd_y}{Prior for the standard deviation of observation equation.}

\item{beta}{Prior for the regression coefficients.}

\item{xreg}{Matrix containing covariates.}
}
\value{
Object of class \code{ar1}.
}
\description{
Constructs a simple Gaussian model where the state dynamics follow an AR(1) process.
}
