% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_draws.R
\name{predict_draws.bgmfit}
\alias{predict_draws.bgmfit}
\alias{predict_draws}
\title{Predicted values from the posterior predictive distribution}
\usage{
\method{predict_draws}{bgmfit}(
  model,
  newdata = NULL,
  resp = NULL,
  ndraws = NULL,
  re_formula = NA,
  allow_new_levels = FALSE,
  sample_new_levels = "uncertainty",
  incl_autocor = TRUE,
  numeric_cov_at = NULL,
  levels_id = NULL,
  avg_reffects = NULL,
  aux_variables = NULL,
  ipts = 10,
  deriv = 0,
  deriv_model = TRUE,
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  xrange = NULL,
  xrange_search = NULL,
  parms_eval = FALSE,
  parms_method = "getPeak",
  idata_method = NULL,
  verbose = FALSE,
  fullframe = NULL,
  dummy_to_factor = NULL,
  usesavedfuns = FALSE,
  clearenvfuns = NULL,
  envir = NULL,
  ...
)

predict_draws(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{newdata}{An optional data frame to be used in estimation. If
\code{NULL} (default), the \code{newdata} is retrieved from the
\code{model}.}

\item{resp}{A character string (default \code{NULL}) to specify response
variable when processing posterior draws for the \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models}

\item{ndraws}{A positive integer indicating the number of posterior draws to
be used in estimation. If \code{NULL} (default), all draws are used.}

\item{re_formula}{Option to indicate whether or not to include the
individual/group-level effects in the estimation. When \code{NA} (default),
the individual-level effects are excluded and therefore population average
growth parameters are computed. When \code{NULL}, individual-level effects
are included in the computation and hence the growth parameters estimates
returned are individual-specific. In both situations, (i.e,, \code{NA} or
\code{NULL}), continuous and factor covariate(s) are appropriately included
in the estimation. The continuous covariates by default are set to their
means (see \code{numeric_cov_at} for details) whereas factor covariates are
left unaltered thereby allowing estimation of covariate specific population
average and individual-specific growth parameter.}

\item{allow_new_levels}{A flag indicating if new levels of group-level
effects are allowed (defaults to \code{FALSE}). Only relevant if
\code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels for grouping
factors specified in \code{re_formula}. This argument is only relevant if
\code{newdata} is provided and \code{allow_new_levels} is set to
\code{TRUE}. If \code{"uncertainty"} (default), each posterior sample for a
new level is drawn from the posterior draws of a randomly chosen existing
level. Each posterior sample for a new level may be drawn from a different
existing level such that the resulting set of new posterior draws
represents the variation across existing levels. If \code{"gaussian"},
sample new levels from the (multivariate) normal distribution implied by the
group-level standard deviations and correlations. This options may be useful
for conducting Bayesian power analysis or predicting new levels in
situations where relatively few levels where observed in the old_data. If
\code{"old_levels"}, directly sample new levels from the existing levels,
where a new level is assigned all of the posterior draws of the same
(randomly chosen) existing level.}

\item{incl_autocor}{A flag indicating if correlation structures originally
specified via \code{autocor} should be included in the predictions.
Defaults to \code{TRUE}.}

\item{numeric_cov_at}{An optional (named list) argument to specify the value
of continuous covariate(s). The default \code{NULL} option set the
continuous covariate(s) at their mean. Alternatively, a named list can be
supplied to manually set these values. For example, \code{numeric_cov_at =
  list(xx = 2)} will set the continuous covariate varibale 'xx' at 2. The
argument \code{numeric_cov_at} is ignored when no continuous covariate is
included in the model.}

\item{levels_id}{An optional argument to specify the \code{ids} for
hierarchical model (default \code{NULL}). It is used only when model is
applied to the data with 3 or more levels of hierarchy. For a two level
model, the \code{levels_id} is automatically inferred from the model fit.
Even for 3 or higher level model, the \code{levels_id} is inferred from the
model fit but under the assumption that hierarchy is specified from lowest
to upper most level i.e, \code{id} followed by \code{study} where \code{id}
is nested within the \code{study} Note that it is not guaranteed that the
\code{levels_id} is sorted correctly, and therefore it is better to set it
manually when fitting a model with three or more levels of hierarchy.}

\item{avg_reffects}{An optional argument (default \code{NULL}) to calculate
(marginal/average) curves and growth parameters (such as APGV and PGV). If
specified, it must be a named list indicating the \code{over} (typically
level 1 predictor, such as age), \code{feby} (fixed effects, typically a
factor variable), and  \code{reby} (typically \code{NULL} indicating that
parameters are integrated over the random effects) such as
\code{avg_reffects = list(feby = 'study', reby = NULL, over = 'age'}.}

\item{aux_variables}{An optional argument to specify the variable(s) that can
be passed to the \code{ipts} argument (see below). This is useful when
fitting location scale models and measurement error models. An
indication to use \code{aux_variables} is when post processing functions
throw an error such as \code{variable 'x' not found either 'data' or
 'data2'}}

\item{ipts}{An integer to set the length of the predictor variable to get a
smooth velocity curve. The \code{NULL} will return original values whereas
an integer such as \code{ipts = 10} (default) will interpolate the
predictor. It is important to note that these interpolations do not alter
the range of predictor when calculating population average and/or the
individual specific growth curves.}

\item{deriv}{An integer to indicate whether to estimate distance curve or its
derivative (i.e., velocity curve). The \code{deriv = 0} (default) is for
the distance curve whereas \code{deriv = 1} for the velocity curve.}

\item{deriv_model}{A logical to specify whether to estimate velocity curve
from the derivative function, or the differentiation of the distance curve.
The argument \code{deriv_model} is set to \code{TRUE} for those functions
which need velocity curve such as \code{growthparameters()} and
\code{plot_curves()}, and \code{NULL} for functions which explicitly use
the distance curve (i.e., fitted values) such as \code{loo_validation()}
and \code{plot_ppc()}.}

\item{summary}{A logical indicating whether only the estimate should be
computed (\code{TRUE}, default), or estimate along with SE and CI should be
returned (\code{FALSE}). Setting \code{summary} as \code{FALSE} will
increase the computation time.}

\item{robust}{A logical to specify the summarize options. If \code{FALSE}
(the default) the mean is used as the measure of central tendency and the
standard deviation as the measure of variability. If \code{TRUE}, the
median and the median absolute deviation (MAD) are applied instead. Ignored
if \code{summary} is \code{FALSE}.}

\item{probs}{The percentiles to be computed by the \code{quantile}
function. Only used if \code{summary} is \code{TRUE}.}

\item{xrange}{An integer to set the predictor range (i.e., age) when
executing the interpolation via \code{ipts}. The default \code{NULL} sets
the individual specific predictor range whereas code \code{xrange = 1} sets
identical range for individuals within the same higher grouping variable
(e.g., study). Code \code{xrange  = 2} sets the identical range across the
entire sample. Lastly, a paired numeric values can be supplied e.g.,
\code{xrange = c(6, 20)} to set the range within those values.}

\item{xrange_search}{A vector of length two, or a character string
\code{'range'} to set the range of predictor variable (\code{x} ) within
which growth parameters are searched. This is useful when there is more
than one peak and user wants to summarize peak within a given range of the
\code{x} variable. Default \code{xrange_search = NULL}.}

\item{parms_eval}{A logical to specify whether or not to get growth
parameters on the fly. This is for internal use only and mainly needed for
compatibility across internal functions.}

\item{parms_method}{A character to specify the method used to when evaluating
\code{parms_eval}. The default is \code{getPeak} which uses the
\code{\link[sitar:getPeakTrough]{sitar::getPeak()}} function from the \code{sitar} package. The alternative
option is \code{findpeaks} that uses the \code{\link[pracma:findpeaks]{pracma::findpeaks()}} function
function from the \code{pracma} package. This is for internal use only and
mainly needed for compatibility across internal functions.}

\item{idata_method}{A character string to indicate the interpolation method.
The number of of interpolation points is set up the \code{ipts} argument.
Options available for \code{idata_method} are \emph{method 1} (specified as
\code{'m1'}) and \emph{method 2} (specified as \code{'m2'}). The
\emph{method 1} (\code{'m1'}) is adapted from the the \pkg{iapvbs} package
and is documented here
\url{https://rdrr.io/github/Zhiqiangcao/iapvbs/src/R/exdata.R}
whereas \emph{method 2} (\code{'m2'}) is based on the \pkg{JMbayes}
package as documented here
\url{https://github.com/drizopoulos/JMbayes/blob/master/R/dynPred_lme.R}.
The \code{'m1'} method works by internally constructing the data frame based
on the model configuration whereas the method \code{'m2'} uses the exact
data frame used in model fit and can be accessed via \code{fit$data}. If
\code{idata_method = NULL, default}, then method \code{'m2'} is
automatically set. Note that method \code{'m1'} might fail in some cases
when model involves covariates particularly when model is fit as
\code{univariate_by}. Therefore, it is advised to switch to method
\code{'m2'} in case \code{'m1'} results in error.}

\item{verbose}{An optional argument (logical, default \code{FALSE}) to
indicate whether to print information collected during setting up the
object(s).}

\item{fullframe}{A logical to indicate whether to return \code{fullframe}
object in which \code{newdata} is bind to the summary estimates. Note that
\code{fullframe} can not be combined with \code{summary = FALSE}.
Furthermore, \code{fullframe} can only be used when \code{idata_method =
  'm2'}. A particular use case is when fitting \code{univariate_by} model.
The \code{fullframe} is mainly for internal use only.}

\item{dummy_to_factor}{A named list (default \code{NULL}) that is used to
convert dummy variables into a factor variable. The named elements are
\code{factor.dummy}, \code{factor.name}, and \code{factor.level}. The
\code{factor.dummy} is a vector of character strings that need to be
converted to a factor variable whereas the \code{factor.name} is a single
character string that is used to name the newly created factor variable.
The \code{factor.level} is used to name the levels of newly created factor.
When \code{factor.name} is \code{NULL}, then the factor name is internally
set as \code{'factor.var'}. If \code{factor.level} is \code{NULL}, then
names of factor levels are take from the \code{factor.dummy} i.e., the
factor levels are assigned same name as \code{factor.dummy}. Note that when
\code{factor.level} is not \code{NULL}, its length must be same as the
length of the \code{factor.dummy}.}

\item{usesavedfuns}{A logical (default \code{FALSE}) to indicate whether to
use the already exposed and saved \code{Stan} functions. This is for
internal purposes only and mainly used during the testing of the functions
and therefore should not be used by users as it might lead to unreliable
estimates.}

\item{clearenvfuns}{A logical to indicate whether to clear the exposed
function from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL} (default), then \code{clearenvfuns} is set as \code{TRUE} when
\code{usesavedfuns} is \code{TRUE}, and \code{FALSE} if \code{usesavedfuns}
is \code{FALSE}.}

\item{envir}{Environment used for function evaluation. The default is
\code{NULL} which will set \code{parent.frame()} as default environment.
Note that since most of post processing functions are based on \pkg{brms},
the functions needed for evaluation should be in the \code{.GlobalEnv}.
Therefore, it is strongly recommended to set \code{ envir = globalenv()}
(or \code{envir = .GlobalEnv}). This is particularly true for the
derivatives such as velocity curve.}

\item{...}{Additional arguments passed to the \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}
function. Please see \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} for details on various
options available.}
}
\value{
An array of predicted response values. See \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}
for details.
}
\description{
The \strong{predict_draws()} is a wrapper around the
\code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} function to obtain predicted values (and their
summary) from the posterior distribution. See \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} for
details.
}
\details{
The \strong{predict_draws()} function computed the fitted values
from the posterior distribution. The \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} function
from the \pkg{brms} package can used to get the predicted (distance) values
when outcome (e.g., height) is untransformed. However, when the outcome is
log or square root transformed, the \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} function will
return the fitted curve on the log or square root scale whereas the
\strong{predict_draws()} function returns the fitted values on the original
scale. Furthermore, the \strong{predict_draws()} also compute the first
derivative of (velocity) that too on the original scale after making
required back-transformation. Except for these differences, both these
functions (i.e., \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} and \code{\link[=predict_draws]{predict_draws()}}) work in
the same manner. In other words, user can specify all the options available
in the \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, a model fitted to the 
# 'berkeley_mdata' has already been saved as 'berkeley_mfit'. 
# Details on 'berkeley_mdata' and 'berkeley_mfit' are provided in the 
# 'bsitar' function.

model <- berkeley_mfit

# Population average distance curve
predict_draws(model, deriv = 0, re_formula = NA)

\donttest{
# Individual-specific distance curves
predict_draws(model, deriv = 0, re_formula = NULL)

# Population average velocity curve
predict_draws(model, deriv = 1, re_formula = NA)

# Individual-specific velocity curves
predict_draws(model, deriv = 1, re_formula = NULL)
 }

}
\seealso{
\code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
