% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bs_select}
\alias{bs_select}
\title{Create a HTML select tag configured with Bootstrap classes}
\usage{
bs_select(
  ...,
  id,
  label = NULL,
  div_class = NULL,
  select_class = "form-select",
  label_class = "form-label",
  text = NULL,
  text_class = "form-text",
  multiple = FALSE,
  select_args = list()
)
}
\arguments{
\item{...}{A string or strings of HTML to pass to html5::select(), most likely a sequence of option tags.}

\item{id}{A string, the id/name for the select, passed to the id and name params of html5::select().}

\item{label}{A string, the label to use for the select, passed to html5::label().}

\item{div_class}{A string, the class of the div tag surrounding the the label and select tags.}

\item{select_class}{A string, the class of the select tag.}

\item{label_class}{A string, the class of the label tag.}

\item{text}{A string, text or HTML to display with the select and label tags.}

\item{text_class}{A string, the class of the text or HTML to display with the select and label tags.}

\item{multiple}{TRUE/FALSE, if TRUE, adds the "multiple" attribute to the select tag.}

\item{select_args}{A named list, names should correspond to a parameter of the html5::select() function and values will be passed to that parameter.}
}
\value{
A string of HTML.
}
\description{
Create a HTML select tag configured with Bootstrap classes
}
\examples{
bs_select(
option(value = 1, "Option One"),
option(value = 2, "Option Two"),
id = "example1",
label = "Example Select Input"
)
}
