% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabs.R
\name{tabsetPanel}
\alias{tabsetPanel}
\title{Create a tabsetPanel}
\usage{
tabsetPanel(
  ...,
  id = NULL,
  selected = NULL,
  type = c("tabs", "pills", "hidden"),
  vertical = FALSE,
  side = "left",
  .list = NULL
)
}
\arguments{
\item{...}{\code{\link[shiny:tabPanel]{tabPanel()}} elements to include in the tabset}

\item{id}{If provided, you can use \verb{input$}\emph{\code{id}} in your
server logic to determine which of the current tabs is active. The value
will correspond to the \code{value} argument that is passed to
\code{\link[shiny:tabPanel]{tabPanel()}}.}

\item{selected}{The \code{value} (or, if none was supplied, the \code{title})
of the tab that should be selected by default. If \code{NULL}, the first
tab will be selected.}

\item{type}{\describe{
  \item{`"tabs"`}{Standard tab look}
  \item{`"pills"`}{Selected tabs use the background fill color}
}}

\item{vertical}{Whether to displays tabs vertically. Default to FALSE.}

\item{side}{Tabs side: \code{"left" or "right"}.}

\item{.list}{In case of programmatically generated items. See example.}
}
\description{
Imported by \link{bs4TabCard} but can be used alone. This is a modified shiny::tabsetPanel,
to handle bootstrap 4. This function will be upgraded 
starting from shiny 1.7.0 (support Bootstrap 4 tabs).
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shinyApp(
   ui = dashboardPage(
    header = dashboardHeader(),
    sidebar = dashboardSidebar(),
    controlbar = dashboardControlbar(),
    footer = dashboardFooter(),
    title = "Bootstrap 4 tabsetPanel",
    body = dashboardBody(
     # manually inserted panels
     tabsetPanel(
      id = "tabcard",
      tabPanel(
       title = "Tab 1", 
       "Content 1"
      ),
      tabPanel(
       title = "Tab 2", 
       "Content 2"
      ),
      tabPanel(
       title = "Tab 3", 
       "Content 3"
      )
     ),
     
     br(), br(),
     # programmatically inserted panels
     tabsetPanel(
       id = "tabset",
       .list = lapply(1:3, function(i) {
         tabPanel(
           title = paste0("Tab", i), 
           active = FALSE,
           paste("Content", i)
         )
       })
      )
    )
   ),
   server = function(input, output) {}
 )
 
 # update tabsetPanel
 shinyApp(
  ui = dashboardPage(
   title = "updateTabsetPanel",
   header = dashboardHeader(),
   body = dashboardBody(
     tabsetPanel(
       id = "tabset1",
       selected = "Tab 2",
       tabPanel(
         title = "Tab 1", 
         numericInput("val", "Value:", 10, min = 1, max = 100),
         verbatimTextOutput("value")
       ),
       tabPanel(
         title = "Tab 2", 
         "Content 2"
       ),
       tabPanel(
         title = "Tab 3", 
         checkboxGroupInput(
           inline = TRUE,
           "variable", "Variables to show:",
           c("Cylinders" = "cyl",
             "Transmission" = "am",
             "Gears" = "gear")
         ),
         tableOutput("data")
       )
     ),
     uiOutput("tabSetPanel2")
   ),
   sidebar = dashboardSidebar(
     skin = "light",
     sliderInput(
       inputId = "controller",
       label = "Update the first tabset",
       min = 1,
       max = 3,
       value = 2
     ),
     br(),
     sliderInput(
       inputId = "controller2",
       label = "Update the second tabset",
       min = 1,
       max = 3,
       value = 3
     )
   ),
   controlbar = dashboardControlbar(collapsed = FALSE),
   footer = dashboardFooter()
 ),
 server = function(input, output, session) {
 
   output$tabSetPanel2 <- renderUI({
    tabsetPanel(
      id = "tabset2",
      tabPanel(
        title = "Tab 1", 
        p("Tab 1 ")
      ),
      tabPanel(
        title = "Tab 2", 
        p("Tab 2")
      ),
      tabPanel(
        title = "Tab 3", 
        p("Tab 3")
      )
    )
   })
   
   # update tabset1
   observeEvent(input$controller, {
     updateTabsetPanel(
       session, 
       inputId = "tabset1", 
       selected = paste("Tab", input$controller)
     )
   }, ignoreInit = TRUE)
   
   # update tabset 2
   observeEvent(input$controller2, {
     updateTabsetPanel(
       session, 
       inputId = "tabset2", 
       selected = paste("Tab", input$controller2)
     )
   }, ignoreInit = TRUE)
   
   output$distPlot <- renderPlot({
     hist(rnorm(input$obs))
   })
   
   output$data <- renderTable({
     mtcars[, c("mpg", input$variable), drop = FALSE]
   }, rownames = TRUE)
   
   output$txt <- renderText({
     paste("You chose", input$rb)
   })
   
   output$value <- renderText({ input$val })
   
  }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
