% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R, R/aliases.R
\name{bs4CardSidebar}
\alias{bs4CardSidebar}
\alias{updatebs4CardSidebar}
\alias{cardSidebar}
\alias{boxSidebar}
\alias{updateCardSidebar}
\alias{updateBoxSidebar}
\title{Create a sidebar for Boostrap 4 card}
\usage{
bs4CardSidebar(
  ...,
  id = NULL,
  width = 50,
  background = "#333a40",
  startOpen = FALSE,
  icon = shiny::icon("cogs"),
  easyClose = TRUE
)

updatebs4CardSidebar(id, session = shiny::getDefaultReactiveDomain())

cardSidebar(
  ...,
  id = NULL,
  width = 50,
  background = "#333a40",
  startOpen = FALSE,
  icon = shiny::icon("cogs"),
  easyClose = TRUE
)

boxSidebar(
  ...,
  id = NULL,
  width = 50,
  background = "#333a40",
  startOpen = FALSE,
  icon = shiny::icon("cogs"),
  easyClose = TRUE
)

updateCardSidebar(id, session = shiny::getDefaultReactiveDomain())

updateBoxSidebar(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{...}{Sidebar content.}

\item{id}{Card sidebar id.}

\item{width}{Sidebar opening width in percentage. 50\% by default, 
means the card sidebar will take 50% of the card width, when opened. 
A numeric value between 25 and 100.}

\item{background}{Sidebar background color. Dark by default.}

\item{startOpen}{Whether the sidebar is open at start. FALSE by default.}

\item{icon}{Sidebar icon. Expect \code{\link[shiny]{icon}}.}

\item{easyClose}{Whether to close sidebar on click outside. Default to TRUE.}

\item{session}{Shiny session object.}
}
\description{
To insert in the sidebar slot of \link{box}.
}
\examples{
# Toggle a box sidebar
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      body = dashboardBody(
        box(
          title = "Update box sidebar",
          closable = TRUE,
          width = 12,
          height = "500px",
          solidHeader = FALSE,
          collapsible = TRUE,
          actionButton("update", "Toggle card sidebar"),
          sidebar = boxSidebar(
            id = "mycardsidebar",
            p("Sidebar Content")
          )
        )
      ),
      sidebar = dashboardSidebar()
    ),
    server = function(input, output, session) {
      observe(print(input$mycardsidebar))

      observeEvent(input$update, {
        updateBoxSidebar("mycardsidebar")
      })
    }
  )
}
}
\seealso{
Other boxWidgets: 
\code{\link{attachmentBlock}()},
\code{\link{bs4CardLabel}()},
\code{\link{bs4Carousel}()},
\code{\link{bs4SocialCard}()},
\code{\link{bs4Timeline}()},
\code{\link{cardDropdown}()},
\code{\link{cardProfile}()},
\code{\link{descriptionBlock}()},
\code{\link{userPost}()}
}
\concept{boxWidgets}
