% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_5_advance.R
\name{ccf_plot}
\alias{ccf_plot}
\title{Cross-correlation analysis.}
\usage{
ccf_plot(
  formula,
  data,
  lag.max = 30,
  sig.level = 0.05,
  xbreaks = seq(-100, 100, 10),
  ybreaks = seq(-1, 1, 0.2),
  ylim = NULL,
  alpha.ns = 1,
  pos.color = "black",
  neg.color = "black",
  ci.color = "blue",
  title = NULL,
  subtitle = NULL,
  xlab = "Lag",
  ylab = "Cross-Correlation"
)
}
\arguments{
\item{formula}{Model formula like \code{y ~ x}.}

\item{data}{Data frame.}

\item{lag.max}{Maximum time lag. Default is \code{30}.}

\item{sig.level}{Significance level. Default is \code{0.05}.}

\item{xbreaks}{X-axis breaks.}

\item{ybreaks}{Y-axis breaks.}

\item{ylim}{Y-axis limits. Default is \code{NULL} to automatically estimate.}

\item{alpha.ns}{Color transparency (opacity: 0~1) for non-significant values.
Default is \code{1} for no transparency (i.e., opaque color).}

\item{pos.color}{Color for positive values. Default is \code{"black"}.}

\item{neg.color}{Color for negative values. Default is \code{"black"}.}

\item{ci.color}{Color for upper and lower bounds of significant values.
Default is \code{"blue"}.}

\item{title}{Plot title. Default is an illustration of the formula.}

\item{subtitle}{Plot subtitle.}

\item{xlab}{X-axis title. Default is \code{"Lag"}.}

\item{ylab}{Y-axis title. Default is \code{"Cross-Correlation"}.}
}
\value{
A \code{gg} object, which you can further modify using
\code{ggplot2} syntax and save using \code{ggsave()}.
}
\description{
Plot the results of cross-correlation analysis using \code{ggplot2}
(rather than R base plot) for more flexible modification of the plot.
}
\details{
Significant correlations with \emph{negative time lags} suggest
shifts in a predictor \emph{precede} shifts in an outcome.
}
\examples{
# resemble the default plot output by `ccf()`
p1 = ccf_plot(chicken ~ egg, data=lmtest::ChickEgg)

# a more colorful plot
p2 = ccf_plot(chicken ~ egg, data=lmtest::ChickEgg, alpha.ns=0.3,
              pos.color="#CD201F",
              neg.color="#21759B",
              ci.color="black")

}
\seealso{
\code{\link{granger_test}}
}
