% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions.R
\name{PGB2Dist}
\alias{PGB2Dist}
\alias{dPGB2}
\alias{pPGB2}
\alias{qPGB2}
\alias{rPGB2}
\alias{summary_PGB2}
\title{Poisson-Gamma-Beta2 distribution}
\usage{
dPGB2(x, a, c, d, tau)

pPGB2(q, a, c, d, tau)

qPGB2(p, a, c, d, tau)

rPGB2(n, a, c, d, tau)

summary_PGB2(a, c, d, tau, output = "list")
}
\arguments{
\item{x,q}{vector of non-negative \strong{integer} quantiles}

\item{a,c,d}{non-negative shape parameters}

\item{tau}{non-negative hyperrate parameter}

\item{p}{vector of probabilities}

\item{n}{number of observations to be sampled}

\item{output}{type of the \code{summary_PGB2} output: \code{"list"} to return a list, \code{"pandoc"} to print a table}
}
\value{
\code{dPGB2} gives the density, \code{pPGB2} the cumulative function,
\code{rPGB2} samples from the distribution, and \code{summary_PGB2} gives
a summary of the distribution.
}
\description{
Density and random generation
for the  Poisson-Gamma-Beta2 distribution
with shape parameters \code{a}, \code{c}, \code{d}
and hyperrate parameter \code{tau} (scale of the Beta2 distribution).
For \code{tau=1} this is the same as the \link[=BNBDist]{Beta-negative binomial distribution}.








}
\details{
This is the mixture distribution obtained by sampling a value \eqn{y}
from the \link[=Beta2Dist]{Beta2 distribution} with shape parameters \eqn{c}, \eqn{d},
and scale \eqn{\tau},
then sampling a value \eqn{\lambda} from the Gamma distribution with
shape \eqn{a} and rate \eqn{y}, and
then sampling the Poisson distribution with mean \eqn{\lambda}.
}
\note{
\code{PGB2Dist} is a generic name for the functions documented.
}
\examples{
a <- 2 ; c <- 5 ; d <- 30; tau <- 2
barplot(dPGB2(0:40, a, c, d, tau), names=0:40)
summary_PGB2(a,c,d,tau, output="pandoc")
}

