% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/brr.R
\name{Brr}
\alias{Brr}
\alias{print.summary.brr}
\alias{summary.brr}
\title{Creation and summary of a \code{brr} object}
\usage{
Brr(...)

\method{summary}{brr}(object, phi0 = 1, hypothesis = "greater", ...)

\method{print}{summary.brr}(x, table.style = "grid", ...)
}
\arguments{
\item{...}{prior parameters \code{a}, \code{b}, \code{c}, \code{d},
samples sizes \code{S}, \code{T}, observed counts \code{x}, \code{y},
future sample sizes \code{Snew}, \code{Tnew}, to be set as in a list (see examples)}

\item{object}{an object of class \code{brr}}

\item{phi0}{the value of interest of the rate ratio}

\item{hypothesis}{\code{"greater"} to return \eqn{Pr(\phi>\phi_0)},
\code{"lower"} to return \eqn{Pr(\phi<\phi_0)}}

\item{x}{the output to be printed}

\item{table.style}{the style of the table to print
(passed to  \code{\link[=pander]{pandoc.table.return}})}
}
\value{
\code{Brr} returns an object of class \code{brr}, \code{summary.brr}
returns a list but prints its contents through \code{print.summary.brr}
}
\description{
Set up the Bayesian model and the observations




}
\examples{
model <- Brr(a=2, b=3)
model()
# add parameters
model <- model(c=4, d=5)
model()
# replace parameters
model <- model(a=10, b=11)
model()
model <- Brr()
summary(model)
model <- Brr(x=3, y=4)
summary(model)
model <- Brr(a=2, b=4, T=10)
summary(model)
model <- model(a=2, b=4, c=3, d=5, S=10, T=10)
summary(model)
model <- model(x=5, y=10)
summary(model)
}

