% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo-tidiers.R
\name{tidy.zoo}
\alias{tidy.zoo}
\alias{zoo_tidiers}
\title{Tidy a(n) zoo object}
\usage{
\method{tidy}{zoo}(x, ...)
}
\arguments{
\item{x}{A \code{zoo} object such as those created by \code{\link[zoo:zoo]{zoo::zoo()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

if (requireNamespace("zoo", quietly = TRUE)) {

library(zoo)
library(ggplot2)

set.seed(1071)

# data generated as shown in the zoo vignette
Z.index <- as.Date(sample(12450:12500, 10))
Z.data <- matrix(rnorm(30), ncol = 3)
colnames(Z.data) <- c("Aa", "Bb", "Cc")
Z <- zoo(Z.data, Z.index)

tidy(Z)

ggplot(tidy(Z), aes(index, value, color = series)) +
  geom_line()

ggplot(tidy(Z), aes(index, value)) +
  geom_line() +
  facet_wrap(~series, ncol = 1)

Zrolled <- rollmean(Z, 5)
ggplot(tidy(Zrolled), aes(index, value, color = series)) +
  geom_line()
  
}
  
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[zoo:zoo]{zoo::zoo()}}

Other time series tidiers: 
\code{\link{tidy.acf}()},
\code{\link{tidy.spec}()},
\code{\link{tidy.ts}()}
}
\concept{time series tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{index}{Index (i.e. date or time) for a `ts` or `zoo` object.}
  \item{series}{Name of the series (present only for multivariate time series).}
  \item{value}{The value/estimate of the component. Results from data reshaping.}

}
