% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm_tidiers.R
\name{geeglm_tidiers}
\alias{geeglm_tidiers}
\alias{tidy.geeglm}
\title{Tidying methods for generalized estimating equations models}
\usage{
\method{tidy}{geeglm}(x, conf.int = FALSE, conf.level = 0.95,
  exponentiate = FALSE, quick = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{geeglm}, such as from \code{geeglm}}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level of the interval, used only if
\code{conf.int=TRUE}}

\item{exponentiate}{whether to exponentiate the coefficient estimates
and confidence intervals (typical for log distributions)}

\item{quick}{whether to compute a smaller and faster version, containing
only the \code{term} and \code{estimate} columns.}

\item{...}{Additional arguments to be passed to other methods.  Currently
not used.}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{tidy.geeglm} returns one row for each coefficient, with five columns:
  \item{term}{The term in the linear model being estimated and tested}
  \item{estimate}{The estimated coefficient}
  \item{std.error}{The standard error from the GEE model}
  \item{statistic}{Wald statistic}
  \item{p.value}{two-sided p-value}

If \code{conf.int=TRUE}, it also includes columns for
\code{conf.low} and \code{conf.high}, computed with
\code{\link{confint.geeglm}} (included as part of broom).
}
\description{
These methods tidy the coefficients of generalized estimating
equations models of the \code{geeglm} class from functions of the
\code{geepack} package.
}
\details{
If \code{conf.int=TRUE}, the confidence interval is computed with
the \code{\link{confint.geeglm}} function.

While \code{tidy} is supported for "geeglm" objects, \code{augment} and
\code{glance} are not.

If you have missing values in your model data, you may need to
refit the model with \code{na.action = na.exclude} or deal with the
missingness in the data beforehand.
}
\examples{

if (require('geepack')) {
    data(state)
    ds <- data.frame(state.region, state.x77)

    geefit <- geeglm(Income ~ Frost + Murder, id = state.region,
                     data = ds, family = gaussian,
                     corstr = 'exchangeable')

    tidy(geefit)
    tidy(geefit, quick = TRUE)
    tidy(geefit, conf.int = TRUE)
}

}

