% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/survival_tidiers.R
\name{cch_tidiers}
\alias{cch_tidiers}
\alias{glance.cch}
\alias{tidy.cch}
\title{tidiers for case-cohort data}
\usage{
\method{tidy}{cch}(x, conf.level = 0.95, ...)

\method{glance}{cch}(x, ...)
}
\arguments{
\item{x}{a "cch" object}

\item{conf.level}{confidence level for CI}

\item{...}{extra arguments (not used)}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy} returns a data.frame with one row for each term
  \item{term}{name of term}
  \item{estimate}{estimate of coefficient}
  \item{stderror}{standard error}
  \item{statistic}{Z statistic}
  \item{p.value}{p-value}
  \item{conf.low}{low end of confidence interval}
  \item{conf.high}{high end of confidence interval}

\code{glance} returns a one-row data.frame with the following
columns:
  \item{score}{score}
  \item{rscore}{rscore}
  \item{p.value}{p-value from Wald test}
  \item{iter}{number of iterations}
  \item{n}{number of predictions}
  \item{nevent}{number of events}
}
\description{
Tidiers for case-cohort analyses: summarize each estimated coefficient,
or test the overall model.
}
\details{
It is not clear what an \code{augment} method would look like,
so none is provided. Nor is there currently any way to extract the
covariance or the residuals.
}
\examples{
if (require("survival", quietly = TRUE)) {
    # examples come from cch documentation
    subcoh <- nwtco$in.subcohort
    selccoh <- with(nwtco, rel==1|subcoh==1)
    ccoh.data <- nwtco[selccoh,]
    ccoh.data$subcohort <- subcoh[selccoh]
    ## central-lab histology
    ccoh.data$histol <- factor(ccoh.data$histol,labels=c("FH","UH"))
    ## tumour stage
    ccoh.data$stage <- factor(ccoh.data$stage,labels=c("I","II","III" ,"IV"))
    ccoh.data$age <- ccoh.data$age/12 # Age in years

    fit.ccP <- cch(Surv(edrel, rel) ~ stage + histol + age, data = ccoh.data,
                   subcoh = ~subcohort, id= ~seqno, cohort.size = 4028)

    tidy(fit.ccP)

    # coefficient plot
    library(ggplot2)
    ggplot(tidy(fit.ccP), aes(x = estimate, y = term)) + geom_point() +
        geom_errorbarh(aes(xmin = conf.low, xmax = conf.high), height = 0) +
        geom_vline(xintercept = 0)

    # compare between methods
    library(dplyr)
    fits <- data_frame(method = c("Prentice", "SelfPrentice", "LinYing")) \%>\%
        group_by(method) \%>\%
        do(tidy(cch(Surv(edrel, rel) ~ stage + histol + age, data = ccoh.data,
                    subcoh = ~subcohort, id= ~seqno, cohort.size = 4028,
                    method = .$method)))

    # coefficient plots comparing methods
    ggplot(fits, aes(x = estimate, y = term, color = method)) + geom_point() +
        geom_errorbarh(aes(xmin = conf.low, xmax = conf.high)) +
        geom_vline(xintercept = 0)
}
}
\seealso{
\link{cch}
}

