% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lme4_tidiers}
\alias{augment.merMod}
\alias{glance.merMod}
\alias{lme4_tidiers}
\alias{tidy.merMod}
\title{Tidying methods for mixed effects models}
\usage{
\method{tidy}{merMod}(x, effects = "random", ...)

\method{augment}{merMod}(x, data = model.frame(x), newdata, ...)

\method{glance}{merMod}(x, ...)
}
\arguments{
\item{x}{An object of class \code{merMod}, such as those from \code{lmer},
\code{glmer}, or \code{nlmer}}

\item{effects}{Either "random" (default) or "fixed"}

\item{...}{extra arguments (not used)}

\item{data}{original data this was fitted on; if not given this will
attempt to be reconstructed}

\item{newdata}{new data to be used for prediction; optional}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{tidy} returns one row for each estimated effect, either
random or fixed depending on the \code{effects} parameter. If
\code{effects = "random"}, it contains the columns
  \item{group}{the group within which the random effect is being estimated}
  \item{level}{level within group}
  \item{term}{term being estimated}
  \item{estimate}{estimated coefficient}

If \code{effects="fixed"}, \code{tidy} returns the columns
  \item{term}{gixed term being estimated}
  \item{estimate}{estimate of fixed effect}
  \item{std.error}{standard error}
  \item{statistic}{t-statistic}
  \item{p.value}{P-value computed from t-statistic (depending on the model,
  this may or may not be calculated and included)}

\code{augment} returns one row for each original observation,
with columns (each prepended by a .) added. Included are the columns
  \item{.fitted}{predicted values}
  \item{.resid}{residuals}
  \item{.fixed}{predicted values with no random effects}

Also added are values from the response object within the model (of type
\code{lmResp}, \code{glmResp}, \code{nlsResp}, etc). These include \code{".mu",
".offset", ".sqrtXwt", ".sqrtrwt", ".eta"}.

\code{glance} returns one row with the columns
  \item{sigma}{the square root of the estimated residual variance}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
  \item{df.residual}{residual degrees of freedom}
}
\description{
These methods tidy the coefficients of mixed effects models, particularly
responses of the \code{merMod} class.
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\examples{
if (require("lme4")) {
    # example regressions are from lme4 documentation
    lmm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
    tidy(lmm1)
    tidy(lmm1, effects = "fixed")
    head(augment(lmm1, sleepstudy))
    glance(lmm1)

    glmm1 <- glmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
                  data = cbpp, family = binomial)
    tidy(glmm1)
    tidy(glmm1, effects = "fixed")
    head(augment(glmm1, cbpp))
    glance(glmm1)

    startvec <- c(Asym = 200, xmid = 725, scal = 350)
    nm1 <- nlmer(circumference ~ SSlogis(age, Asym, xmid, scal) ~ Asym|Tree,
                  Orange, start = startvec)
    tidy(nm1)
    tidy(nm1, effects = "fixed")
    head(augment(nm1, Orange))
    glance(nm1)
}
}
\seealso{
\link{na.action}
}

