% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCglmm_tidiers.R, R/mcmc_tidiers.R
\name{tidy.MCMCglmm}
\alias{tidy.MCMCglmm}
\alias{mcmc_tidiers}
\alias{tidyMCMC}
\alias{tidy.rjags}
\alias{tidy.stanfit}
\alias{tidy.mcmc}
\alias{tidy.mcmc.list}
\title{Tidying methods for MCMC (Stan, JAGS, etc.) fits}
\usage{
\method{tidy}{MCMCglmm}(x, effects = c("fixed", "ran_pars"),
  scales = NULL, ...)

tidyMCMC(x, pars, robust = FALSE, conf.int = FALSE,
  conf.level = 0.95, conf.method = c("quantile", "HPDinterval"),
  drop.pars = c("lp__", "deviance"), rhat = FALSE, ess = FALSE,
  index = FALSE, ...)

\method{tidy}{rjags}(x, robust = FALSE, conf.int = FALSE,
  conf.level = 0.95, conf.method = "quantile", ...)

\method{tidy}{stanfit}(x, pars, robust = FALSE, conf.int = FALSE,
  conf.level = 0.95, conf.method = c("quantile", "HPDinterval"),
  drop.pars = c("lp__", "deviance"), rhat = FALSE, ess = FALSE,
  index = FALSE, ...)

\method{tidy}{mcmc}(x, pars, robust = FALSE, conf.int = FALSE,
  conf.level = 0.95, conf.method = c("quantile", "HPDinterval"),
  drop.pars = c("lp__", "deviance"), rhat = FALSE, ess = FALSE,
  index = FALSE, ...)

\method{tidy}{mcmc.list}(x, pars, robust = FALSE, conf.int = FALSE,
  conf.level = 0.95, conf.method = c("quantile", "HPDinterval"),
  drop.pars = c("lp__", "deviance"), rhat = FALSE, ess = FALSE,
  index = FALSE, ...)
}
\arguments{
\item{x}{a model fit to be converted to a data frame}

\item{effects}{which effects (fixed, random, etc.) to return}

\item{scales}{scales on which to report results}

\item{...}{mostly unused; for \code{tidy.MCMCglmm}, these represent options
passed through to \code{tidy.mcmc} (e.g. \code{robust}, \code{conf.int}, \code{conf.method}, ...)}

\item{pars}{(character) specification of which parameters to include}

\item{robust}{use mean and standard deviation (if FALSE) or median and mean absolute deviation (if TRUE) to compute point estimates and uncertainty?}

\item{conf.int}{(logical) include confidence interval?}

\item{conf.level}{probability level for CI}

\item{conf.method}{method for computing confidence intervals
("quantile" or "HPDinterval")}

\item{drop.pars}{Parameters not to include in the output (such
as log-probability information)}

\item{rhat, ess}{(logical) include Rhat and/or effective sample size estimates?}

\item{index}{Add index column, remove index from term. For example,
\code{term a[13]} becomes \code{term a} and \code{index 13}.}
}
\description{
Tidying methods for MCMC (Stan, JAGS, etc.) fits
}
\examples{
if (require("MCMCglmm")) {
  ## original model
  \dontrun{
      mm0 <- MCMCglmm(Reaction ~ Days,
                 random = ~Subject, data = sleepstudy,
                 nitt=4000,
                 pr = TRUE
             )
   }
   ## load stored object
   load(system.file("extdata","MCMCglmm_example.rda",
                                     package="broom.mixed"))
   tidy(mm0)
   tidy(mm1)
   tidy(mm2)
   tail(tidy(mm0,effects="ran_vals"))
}

# Using example from "RStan Getting Started"
# https://github.com/stan-dev/rstan/wiki/RStan-Getting-Started

model_file <- system.file("extdata", "8schools.stan", package = "broom.mixed")
schools_dat <- list(J = 8,
                    y = c(28,  8, -3,  7, -1,  1, 18, 12),
                    sigma = c(15, 10, 16, 11,  9, 11, 10, 18))
## original model
\dontrun{
    set.seed(2015)
    rstan_example <- rstan::stan(file = model_file, data = schools_dat,
                         iter = 1000, chains = 2, save_dso = FALSE)
}
if (require(rstan)) {
   ## load stored object
   rstan_example <- readRDS(system.file("extdata", "rstan_example.rds", package = "broom.mixed"))
   tidy(rstan_example)
   tidy(rstan_example, conf.int = TRUE, pars = "theta")
   td_mean <- tidy(rstan_example, conf.int = TRUE)
   td_median <- tidy(rstan_example, conf.int = TRUE, robust = TRUE)

  if (require(dplyr) && require(ggplot2)) {
    tds <- rbind(mutate(td_mean, method = "mean"),
             mutate(td_median, method = "median")) \%>\%
       mutate(type=ifelse(grepl("^theta",term),"theta",
            ifelse(grepl("^eta",term),"eta",
                  "other")))

     ggplot(tds, aes(estimate, term)) +
      geom_errorbarh(aes(xmin = conf.low, xmax = conf.high),height=0) +
      geom_point(aes(color = method))+
      facet_wrap(~type,scale="free",ncol=1)
 } ## require(dplyr,ggplot2)
} ## require(rstan)
if (require(R2jags)) {
   ## see help("jags",package="R2jags")
   ## and  example("jags",package="R2jags")
   ## for details
   ## load stored object
   R2jags_example <- readRDS(system.file("extdata", "R2jags_example.rds", package = "broom.mixed"))
   tidy(R2jags_example)
   tidy(R2jags_example, conf.int=TRUE, conf.method="quantile")
}

}
