% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_add_term_labels.R
\name{tidy_add_term_labels}
\alias{tidy_add_term_labels}
\title{Add term labels}
\usage{
tidy_add_term_labels(
  x,
  labels = NULL,
  interaction_sep = " * ",
  categorical_terms_pattern = "{level}",
  model = tidy_get_model(x),
  quiet = FALSE,
  strict = FALSE
)
}
\arguments{
\item{x}{a tidy tibble}

\item{labels}{an optional named list or named vector of
custom term labels}

\item{interaction_sep}{separator for interaction terms}

\item{categorical_terms_pattern}{a \link[glue:glue]{glue pattern} for
labels of categorical terms with treatment or sum contrasts
(see examples and \code{\link[=model_list_terms_levels]{model_list_terms_levels()}})}

\item{model}{the corresponding model, if not attached to \code{x}}

\item{quiet}{logical argument whether broom.helpers should not return a message
when requested output cannot be generated. Default is FALSE}

\item{strict}{logical argument whether broom.helpers should return an error
when requested output cannot be generated. Default is FALSE}
}
\description{
Will add term labels in a \code{label} column, based on:
\enumerate{
\item labels provided in \code{labels} argument if provided;
\item factor levels for categorical variables coded with
treatment, SAS or sum contrasts (the label could be
customized with \code{categorical_terms_pattern} argument);
\item variable labels when there is only one term per variable;
\item term name otherwise.
}
}
\details{
If the \code{variable_label} column is not yet available in \code{x},
\code{\link[=tidy_add_variable_labels]{tidy_add_variable_labels()}} will be automatically applied.
If the \code{contrasts} column is not yet available in \code{x},
\code{\link[=tidy_add_contrasts]{tidy_add_contrasts()}} will be automatically applied.

It is possible to pass a custom label for any term in \code{labels},
including interaction terms.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
df <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes"))) \%>\%
  labelled::set_variable_labels(
    Class = "Passenger's class",
    Sex = "Sex"
  )

mod <- df \%>\%
  glm(Survived ~ Class * Age * Sex, data = ., weights = .$n, family = binomial)
mod \%>\%
  tidy_and_attach() \%>\%
  tidy_add_term_labels()
mod \%>\%
  tidy_and_attach() \%>\%
  tidy_add_term_labels(
    interaction_sep = " x ",
    categorical_terms_pattern = "{level} / {reference_level}"
  )
\dontshow{\}) # examplesIf}
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
