% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{bayes_R2.brmsfit}
\alias{bayes_R2.brmsfit}
\alias{bayes_R2}
\title{Compute a Bayesian version of R-squared for regression models}
\usage{
\method{bayes_R2}{brmsfit}(object, newdata = NULL, re_formula = NULL,
  allow_new_levels = FALSE, sample_new_levels = "uncertainty",
  new_objects = list(), incl_autocor = TRUE, subset = NULL,
  nsamples = NULL, resp = NULL, nug = NULL, summary = TRUE,
  robust = FALSE, probs = c(0.025, 0.975), ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the original data of the model is used.}

\item{re_formula}{formula containing group-level effects 
to be considered in the prediction. 
If \code{NULL} (default), include all group-level effects; 
if \code{NA}, include no group-level effects.}

\item{allow_new_levels}{A flag indicating if new
levels of group-level effects are allowed 
(defaults to \code{FALSE}). 
Only relevant if \code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels 
for grouping factors specified in \code{re_formula}.
This argument is only relevant if \code{newdata} is provided and 
\code{allow_new_levels} is set to \code{TRUE}.
If \code{"uncertainty"} (default), include group-level uncertainty
in the predictions based on the variation of the existing levels. 
If \code{"gaussian"}, sample new levels from the (multivariate) 
normal distribution implied by the group-level standard deviations 
and correlations. This options may be useful for conducting 
Bayesian power analysis. 
If \code{"old_levels"}, directly sample new levels from the
existing levels.}

\item{new_objects}{A named \code{list} of objects containing 
new data, which cannot be passed via argument \code{newdata}.
Currently, only required for objects passed to 
\code{\link[brms:cor_sar]{cor_sar}} and 
\code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{incl_autocor}{A flag indicating if ARMA autocorrelation
parameters should be included in the predictions. Defaults to 
\code{TRUE}. Setting it to \code{FALSE} will not affect other 
correlation structures such as \code{\link[brms:cor_bsts]{cor_bsts}},
or \code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{subset}{A numeric vector specifying
the posterior samples to be used. 
If \code{NULL} (the default), all samples are used.}

\item{nsamples}{Positive integer indicating how many 
posterior samples should be used. 
If \code{NULL} (the default) all samples are used.
Ignored if \code{subset} is not \code{NULL}.}

\item{resp}{Optional names of response variables.
If specified, fitted values of these response variables are returned.}

\item{nug}{Small positive number for Gaussian process terms only. 
For numerical reasons, the covariance matrix of a Gaussian 
process might not be positive definite. Adding a very small 
number to the matrix's diagonal often solves this problem. 
If \code{NULL} (the default), \code{nug} is chosen internally.}

\item{summary}{Should summary statistics 
 (i.e. means, sds, and 95\% intervals) be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{...}{Currently ignored.}
}
\value{
If \code{summary = TRUE} a 1 x C matrix is returned
 (\code{C = length(probs) + 2}) containing summary statistics
 of Bayesian R-squared values.
 If \code{summary = FALSE} the posterior samples of the R-squared values
 are returned in a S x 1 matrix (S is the number of samples).
}
\description{
Compute a Bayesian version of R-squared for regression models
}
\details{
For an introduction to the approach, see
  \url{https://github.com/jgabry/bayes_R2/blob/master/bayes_R2.pdf}.
}
\examples{
\dontrun{
fit <- brm(mpg ~ wt + cyl, data = mtcars)
summary(fit)
bayes_R2(fit)

# compute R2 with new data
nd <- data.frame(mpg = c(10, 20, 30), wt = c(4, 3, 2), cyl = c(8, 6, 4))
bayes_R2(fit, newdata = nd)
}

}
