% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{log_lik.brmsfit}
\alias{log_lik.brmsfit}
\alias{log_lik}
\alias{logLik.brmsfit}
\title{Compute the Pointwise Log-Likelihood}
\usage{
\method{log_lik}{brmsfit}(object, newdata = NULL, re_formula = NULL,
  allow_new_levels = FALSE, sample_new_levels = "uncertainty",
  new_objects = list(), incl_autocor = TRUE, resp = NULL, subset = NULL,
  nsamples = NULL, pointwise = FALSE, nug = NULL, combine = TRUE, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the original data of the model is used.}

\item{re_formula}{formula containing group-level effects 
to be considered in the prediction. 
If \code{NULL} (default), include all group-level effects; 
if \code{NA}, include no group-level effects.}

\item{allow_new_levels}{A flag indicating if new
levels of group-level effects are allowed 
(defaults to \code{FALSE}). 
Only relevant if \code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels 
for grouping factors specified in \code{re_formula}.
This argument is only relevant if \code{newdata} is provided and 
\code{allow_new_levels} is set to \code{TRUE}.
If \code{"uncertainty"} (default), include group-level uncertainty
in the predictions based on the variation of the existing levels. 
If \code{"gaussian"}, sample new levels from the (multivariate) 
normal distribution implied by the group-level standard deviations 
and correlations. This options may be useful for conducting 
Bayesian power analysis. 
If \code{"old_levels"}, directly sample new levels from the
existing levels.}

\item{new_objects}{A named \code{list} of objects containing 
new data, which cannot be passed via argument \code{newdata}.
Currently, only required for objects passed to 
\code{\link[brms:cor_sar]{cor_sar}} and 
\code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{incl_autocor}{A flag indicating if ARMA autocorrelation
parameters should be included in the predictions. Defaults to 
\code{TRUE}. Setting it to \code{FALSE} will not affect other 
correlation structures such as \code{\link[brms:cor_bsts]{cor_bsts}},
or \code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{resp}{Optional names of response variables.
If specified, fitted values of these response variables are returned.}

\item{subset}{A numeric vector specifying
the posterior samples to be used. 
If \code{NULL} (the default), all samples are used.}

\item{nsamples}{Positive integer indicating how many 
posterior samples should be used. 
If \code{NULL} (the default) all samples are used.
Ignored if \code{subset} is not \code{NULL}.}

\item{pointwise}{A flag indicating whether to compute the full
log-likelihood matrix at once (the default), or just return
the likelihood function along with all data and samples
required to compute the log-likelihood separately for each
observation. The latter option is rarely useful when
calling \code{log_lik} directly, but rather when computing
\code{\link[brms:WAIC]{WAIC}} or \code{\link[brms:LOO]{LOO}}.}

\item{nug}{Small positive number for Gaussian process terms only. 
For numerical reasons, the covariance matrix of a Gaussian 
process might not be positive definite. Adding a very small 
number to the matrix's diagonal often solves this problem. 
If \code{NULL} (the default), \code{nug} is chosen internally.}

\item{combine}{Only relevant in multivariate models.
Indicates if the log-likelihoods of the submodels should
be combined per observation (i.e. added together; the default) 
or if the log-likelihoods should be returned separately.}

\item{...}{Currently ignored}
}
\value{
Usually, an S x N matrix containing the pointwise log-likelihood
 samples, where S is the number of samples and N is the number 
 of observations in the data. For multivariate models and if 
 \code{combine} is \code{FALSE}, an S x N x R array is returned, 
 where R is the number of response variables.
 If \code{pointwise = TRUE}, the output is a function
 with a \code{draws} attribute containing all relevant
 data and posterior samples.
}
\description{
Compute the Pointwise Log-Likelihood
}
