% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_data_change.R
\name{brm_data_change}
\alias{brm_data_change}
\title{Convert to change from baseline.}
\usage{
brm_data_change(data, name_change = "change", name_baseline = "baseline")
}
\arguments{
\item{data}{A classed \code{tibble} (e.g. from \code{\link[=brm_data]{brm_data()}}) with raw response
as the outcome variable (role = \code{"response"} in \code{\link[=brm_data]{brm_data()}}).}

\item{name_change}{Character of length 1, name of the new outcome column
for change from baseline.}

\item{name_baseline}{Character of length 1, name of the new column for
the original baseline response.}
}
\value{
A classed \code{tibble} with change from baseline as the outcome variable
and the internal attributes modified accordingly. A special baseline
column is also created, and the original raw response column is removed.
The new baseline column is comprised of the elements of the response
variable corresponding to the \code{reference_time} argument of \code{\link[=brm_data]{brm_data()}}.

If there is a column to denote missing values for simulation purposes,
e.g. the \code{"missing"} column generated by \code{brm_simulate_outline()},
then missing baseline values are propagated accordingly such that
change from baseline will be missing if either the post-baseline response
is missing or the baseline response is missing.
}
\description{
Convert a dataset from raw response to change from baseline.
}
\examples{
set.seed(0)
data <- brm_data(
  data = dplyr::rename(brm_simulate_simple()$data, y_values = response),
  outcome = "y_values",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient",
  reference_group = "group_1",
  reference_time = "time_1"
)
data
attr(data, "brm_role")
attr(data, "brm_outcome")
attr(data, "brm_baseline")
attr(data, "brm_reference_time")
changed <- brm_data_change(data = data, name_change = "delta")
changed
attr(changed, "brm_role")
attr(changed, "brm_outcome")
attr(changed, "brm_baseline")
attr(data, "brm_reference_time")
}
\seealso{
Other data: 
\code{\link{brm_data}()}
}
\concept{data}
