% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brif.R
\name{brif.formula}
\alias{brif.formula}
\title{Build a model (and make predictions) with formula}
\usage{
\method{brif}{formula}(
  formula,
  data,
  subset,
  na.action = stats::na.pass,
  newdata = NULL,
  type = c("score", "class"),
  ...
)
}
\arguments{
\item{formula}{an object of class "\code{\link[stats]{formula}}": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by \code{\link{as.data.frame}} to a data frame) containing the variables in the model. If not found in \code{data}, the variables are taken from \code{environment(formula)}, typically the environment from which \code{brif.formula} is called.}

\item{subset}{an optional vector specifying a subset (in terms of index numbers, not actual data) of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain NAs.}

\item{newdata}{a data frame containing the data set for prediction. Default is NULL. If newdata is supplied, prediction results will be returned.}

\item{type}{a character string specifying the prediction format, which takes effect only when \code{newdata} is supplied. Available values include "score" and "class". Default is "score".}

\item{...}{additional algorithmic parameters. See \code{\link[brif]{brif.default}} for a complete list.}
}
\value{
an object of class \code{brif} to be used by \code{\link{predict.brif}}.
}
\description{
Build a model (and make predictions) with formula
}
\examples{
bf <- brif(Species ~ ., data = iris)
pred <- predict(bf, iris[,1:4])
}
