% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brglm2-package.R
\docType{package}
\name{brglm2}
\alias{brglm2}
\alias{brglm2-package}
\title{brglm2: Bias Reduction in Generalized Linear Models}
\description{
Estimation and inference from generalized linear models using
implicit and explicit bias reduction methods (Kosmidis, 2014), and
other penalized maximum likelihood methods. Currently supported
methods include the mean bias-reducing adjusted scores approach in
Firth (1993) and Kosmidis & Firth (2009), the median bias-reduction
adjusted scores approach in Kenne Pagui et al. (2017), the
correction of the asymptotic bias in Cordeiro & McCullagh (1991),
the mixed bias-reduction adjusted scores approach in Kosmidis et al
(2019), maximum penalized likelihood with powers of the Jeffreys
prior as penalty, and maximum likelihood.
}
\details{
In the special case of generalized linear models for binomial,
Poisson and multinomial responses (both nominal and ordinal), mean
and median bias reduction and maximum penalized likelihood return
estimates with improved frequentist properties, that are also
always finite, even in cases where the maximum likelihood estimates
are infinite (e.g. complete and quasi-complete separation in
multinomial regression; see also \code{\link{detect_separation}}
and \code{\link{check_infinite_estimates}} for pre-fit and post-fit
methods for the detection of infinite estimates in binomial
response generalized linear models). Estimation in all cases takes
place via a modified Fisher scoring algorithm, and S3 methods for
the construction of confidence intervals for the reduced-bias
estimates are provided.

The core model fitters are implemented by the functions
\code{\link{brglm_fit}} (univariate generalized linear models),
\code{\link{brmultinom}} (baseline category logit models for
nominal multinomial responses), and \code{\link{bracl}} (adjacent
category logit models for ordinal multinomial responses).




The similarly named **brglm** R package can only handle generalized
linear models with binomial responses. Special care has been taken
when developing **brglm2** in order not to have conflicts when the
user loads **brglm2** and **brglm** simultaneously. The development
and maintenance of the two packages will continue in parallel,
until **brglm2** incorporates all **brglm** functionality and gets
an appropriate wrapper to the \code{brglm::brglm} function.
}
\references{
Cordeiro G. M. & McCullagh, P. (1991). Bias correction in generalized
linear models. *Journal of the Royal Statistical Society. Series B
(Methodological)*, **53**, 629-643

Firth D. (1993). Bias reduction of maximum likelihood estimates,
Biometrika, **80**, 27-38

Kenne Pagui E C, Salvan A and Sartori N (2016). Median bias
reduction of maximum likelihood estimates. *arXiv*,
**arXiv:1604.04768**

Kosmidis I and Firth D (2009). Bias reduction in exponential family
nonlinear models. *Biometrika*, **96**, 793-804

Kosmidis I and Firth D (2010). A generic algorithm for reducing
bias in parametric estimation. *Electronic Journal of Statistics*,
**4**, 1097-1112

Kosmidis I (2014). Bias in parametric estimation: reduction and
useful side-effects. *WIRE Computational Statistics*, **6**,
185-196
}
\seealso{
\code{\link{brglm_fit}}, \code{\link{brmultinom}}, \code{\link{bracl}}
}
\author{
Ioannis Kosmidis \email{ioannis.kosmidis@warwick.ac.uk}
}
