// Generated by rstantools.  Do not edit by hand.

/*
    breathteststan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    breathteststan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with breathteststan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
#ifndef USE_STANC3
#define USE_STANC3
#endif
// Code generated by stanc v2.26.0
#include <stan/model/model_header.hpp>
namespace model_breath_test_1_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 12, column 2 to column 25)",
                                                      " (in 'string', line 13, column 2 to column 21)",
                                                      " (in 'string', line 14, column 2 to column 24)",
                                                      " (in 'string', line 15, column 2 to column 25)",
                                                      " (in 'string', line 16, column 2 to column 21)",
                                                      " (in 'string', line 17, column 2 to column 24)",
                                                      " (in 'string', line 18, column 2 to column 28)",
                                                      " (in 'string', line 19, column 2 to column 24)",
                                                      " (in 'string', line 20, column 2 to column 27)",
                                                      " (in 'string', line 21, column 2 to column 23)",
                                                      " (in 'string', line 24, column 2 to column 30)",
                                                      " (in 'string', line 25, column 2 to column 30)",
                                                      " (in 'string', line 26, column 2 to column 33)",
                                                      " (in 'string', line 28, column 2 to column 32)",
                                                      " (in 'string', line 29, column 2 to column 32)",
                                                      " (in 'string', line 30, column 2 to column 41)",
                                                      " (in 'string', line 34, column 2 to column 23)",
                                                      " (in 'string', line 35, column 2 to column 23)",
                                                      " (in 'string', line 36, column 2 to column 25)",
                                                      " (in 'string', line 37, column 2 to column 23)",
                                                      " (in 'string', line 38, column 2 to column 26)",
                                                      " (in 'string', line 39, column 2 to column 29)",
                                                      " (in 'string', line 40, column 2 to column 26)",
                                                      " (in 'string', line 41, column 2 to column 26)",
                                                      " (in 'string', line 42, column 2 to column 27)",
                                                      " (in 'string', line 43, column 2 to column 22)",
                                                      " (in 'string', line 45, column 11 to column 12)",
                                                      " (in 'string', line 45, column 4 to column 19)",
                                                      " (in 'string', line 47, column 6 to column 14)",
                                                      " (in 'string', line 48, column 6 to column 14)",
                                                      " (in 'string', line 49, column 6 to column 19)",
                                                      " (in 'string', line 50, column 6 to column 14)",
                                                      " (in 'string', line 51, column 6 to column 17)",
                                                      " (in 'string', line 52, column 6 to column 27)",
                                                      " (in 'string', line 53, column 6 to column 20)",
                                                      " (in 'string', line 54, column 6 to column 18)",
                                                      " (in 'string', line 55, column 6 to column 36)",
                                                      " (in 'string', line 56, column 6 to column 24)",
                                                      " (in 'string', line 57, column 6 to column 71)",
                                                      " (in 'string', line 46, column 18 to line 58, column 5)",
                                                      " (in 'string', line 46, column 4 to line 58, column 5)",
                                                      " (in 'string', line 62, column 6 to column 32)",
                                                      " (in 'string', line 60, column 6 to column 49)",
                                                      " (in 'string', line 59, column 4 to line 62, column 32)",
                                                      " (in 'string', line 44, column 2 to line 63, column 3)",
                                                      " (in 'string', line 3, column 2 to column 17)",
                                                      " (in 'string', line 4, column 2 to column 24)",
                                                      " (in 'string', line 5, column 2 to column 28)",
                                                      " (in 'string', line 6, column 2 to column 21)",
                                                      " (in 'string', line 7, column 27 to column 28)",
                                                      " (in 'string', line 7, column 2 to column 30)",
                                                      " (in 'string', line 8, column 18 to column 19)",
                                                      " (in 'string', line 8, column 2 to column 28)",
                                                      " (in 'string', line 9, column 20 to column 21)",
                                                      " (in 'string', line 9, column 2 to column 27)",
                                                      " (in 'string', line 12, column 9 to column 17)",
                                                      " (in 'string', line 15, column 9 to column 17)",
                                                      " (in 'string', line 18, column 9 to column 17)",
                                                      " (in 'string', line 24, column 18 to column 26)",
                                                      " (in 'string', line 25, column 18 to column 26)",
                                                      " (in 'string', line 26, column 18 to column 26)"};
#include <stan_meta_header.hpp>
class model_breath_test_1 final : public model_base_crtp<model_breath_test_1> {
 private:
  int n;
  int n_record;
  int student_t_df;
  double dose;
  std::vector<int> pat_group_i;
  Eigen::Matrix<double, -1, 1> minute;
  Eigen::Matrix<double, -1, 1> pdr;
 
 public:
  ~model_breath_test_1() { }
  
  inline std::string model_name() const final { return "model_breath_test_1"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.0", "stancflags = "};
  }
  
  
  model_breath_test_1(stan::io::var_context& context__,
                      unsigned int random_seed__ = 0,
                      std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_breath_test_1_namespace::model_breath_test_1";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 46;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 46;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 46;
      current_statement__ = 46;
      check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 47;
      context__.validate_dims("data initialization","n_record","int",
          context__.to_vec());
      n_record = std::numeric_limits<int>::min();
      
      current_statement__ = 47;
      n_record = context__.vals_i("n_record")[(1 - 1)];
      current_statement__ = 47;
      current_statement__ = 47;
      check_greater_or_equal(function__, "n_record", n_record, 0);
      current_statement__ = 48;
      context__.validate_dims("data initialization","student_t_df","int",
          context__.to_vec());
      student_t_df = std::numeric_limits<int>::min();
      
      current_statement__ = 48;
      student_t_df = context__.vals_i("student_t_df")[(1 - 1)];
      current_statement__ = 48;
      current_statement__ = 48;
      check_greater_or_equal(function__, "student_t_df", student_t_df, 1);
      current_statement__ = 49;
      context__.validate_dims("data initialization","dose","double",
          context__.to_vec());
      dose = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 49;
      dose = context__.vals_r("dose")[(1 - 1)];
      current_statement__ = 49;
      current_statement__ = 49;
      check_greater_or_equal(function__, "dose", dose, 0);
      current_statement__ = 50;
      validate_non_negative_index("pat_group_i", "n", n);
      current_statement__ = 51;
      context__.validate_dims("data initialization","pat_group_i","int",
          context__.to_vec(n));
      pat_group_i = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 51;
      assign(pat_group_i, nil_index_list(), context__.vals_i("pat_group_i"),
        "assigning variable pat_group_i");
      current_statement__ = 51;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 51;
        current_statement__ = 51;
        check_greater_or_equal(function__, "pat_group_i[sym1__]",
                               pat_group_i[(sym1__ - 1)], 0);}
      current_statement__ = 52;
      validate_non_negative_index("minute", "n", n);
      current_statement__ = 53;
      context__.validate_dims("data initialization","minute","double",
          context__.to_vec(n));
      minute = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(minute, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> minute_flat__;
        current_statement__ = 53;
        assign(minute_flat__, nil_index_list(), context__.vals_r("minute"),
          "assigning variable minute_flat__");
        current_statement__ = 53;
        pos__ = 1;
        current_statement__ = 53;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 53;
          assign(minute, cons_list(index_uni(sym1__), nil_index_list()),
            minute_flat__[(pos__ - 1)], "assigning variable minute");
          current_statement__ = 53;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 53;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 53;
        current_statement__ = 53;
        check_greater_or_equal(function__, "minute[sym1__]",
                               minute[(sym1__ - 1)], 0);}
      current_statement__ = 54;
      validate_non_negative_index("pdr", "n", n);
      current_statement__ = 55;
      context__.validate_dims("data initialization","pdr","double",
          context__.to_vec(n));
      pdr = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(pdr, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> pdr_flat__;
        current_statement__ = 55;
        assign(pdr_flat__, nil_index_list(), context__.vals_r("pdr"),
          "assigning variable pdr_flat__");
        current_statement__ = 55;
        pos__ = 1;
        current_statement__ = 55;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 55;
          assign(pdr, cons_list(index_uni(sym1__), nil_index_list()),
            pdr_flat__[(pos__ - 1)], "assigning variable pdr");
          current_statement__ = 55;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 55;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 55;
        current_statement__ = 55;
        check_greater_or_equal(function__, "pdr[sym1__]", pdr[(sym1__ - 1)],
                               -30);}
      current_statement__ = 56;
      validate_non_negative_index("m_raw", "n_record", n_record);
      current_statement__ = 57;
      validate_non_negative_index("k_raw", "n_record", n_record);
      current_statement__ = 58;
      validate_non_negative_index("beta_raw", "n_record", n_record);
      current_statement__ = 59;
      validate_non_negative_index("m", "n_record", n_record);
      current_statement__ = 60;
      validate_non_negative_index("k", "n_record", n_record);
      current_statement__ = 61;
      validate_non_negative_index("beta", "n_record", n_record);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += n_record;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += n_record;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += n_record;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_breath_test_1_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> m_raw;
      m_raw = Eigen::Matrix<local_scalar_t__, -1, 1>(n_record);
      stan::math::fill(m_raw, DUMMY_VAR__);
      
      current_statement__ = 1;
      m_raw = in__.vector(n_record);
      local_scalar_t__ mu_m;
      mu_m = DUMMY_VAR__;
      
      current_statement__ = 2;
      mu_m = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        mu_m = stan::math::lb_constrain(mu_m, 0, lp__);
      } else {
        current_statement__ = 2;
        mu_m = stan::math::lb_constrain(mu_m, 0);
      }
      local_scalar_t__ sigma_m;
      sigma_m = DUMMY_VAR__;
      
      current_statement__ = 3;
      sigma_m = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        sigma_m = stan::math::lb_constrain(sigma_m, 0, lp__);
      } else {
        current_statement__ = 3;
        sigma_m = stan::math::lb_constrain(sigma_m, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> k_raw;
      k_raw = Eigen::Matrix<local_scalar_t__, -1, 1>(n_record);
      stan::math::fill(k_raw, DUMMY_VAR__);
      
      current_statement__ = 4;
      k_raw = in__.vector(n_record);
      local_scalar_t__ mu_k;
      mu_k = DUMMY_VAR__;
      
      current_statement__ = 5;
      mu_k = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        mu_k = stan::math::lb_constrain(mu_k, 0, lp__);
      } else {
        current_statement__ = 5;
        mu_k = stan::math::lb_constrain(mu_k, 0);
      }
      local_scalar_t__ sigma_k;
      sigma_k = DUMMY_VAR__;
      
      current_statement__ = 6;
      sigma_k = in__.scalar();
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        sigma_k = stan::math::lb_constrain(sigma_k, 0, lp__);
      } else {
        current_statement__ = 6;
        sigma_k = stan::math::lb_constrain(sigma_k, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> beta_raw;
      beta_raw = Eigen::Matrix<local_scalar_t__, -1, 1>(n_record);
      stan::math::fill(beta_raw, DUMMY_VAR__);
      
      current_statement__ = 7;
      beta_raw = in__.vector(n_record);
      local_scalar_t__ mu_beta;
      mu_beta = DUMMY_VAR__;
      
      current_statement__ = 8;
      mu_beta = in__.scalar();
      current_statement__ = 8;
      if (jacobian__) {
        current_statement__ = 8;
        mu_beta = stan::math::lb_constrain(mu_beta, 0, lp__);
      } else {
        current_statement__ = 8;
        mu_beta = stan::math::lb_constrain(mu_beta, 0);
      }
      local_scalar_t__ sigma_beta;
      sigma_beta = DUMMY_VAR__;
      
      current_statement__ = 9;
      sigma_beta = in__.scalar();
      current_statement__ = 9;
      if (jacobian__) {
        current_statement__ = 9;
        sigma_beta = stan::math::lb_constrain(sigma_beta, 0, lp__);
      } else {
        current_statement__ = 9;
        sigma_beta = stan::math::lb_constrain(sigma_beta, 0);
      }
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 10;
      sigma = in__.scalar();
      current_statement__ = 10;
      if (jacobian__) {
        current_statement__ = 10;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 10;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> m;
      m = Eigen::Matrix<local_scalar_t__, -1, 1>(n_record);
      stan::math::fill(m, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> k;
      k = Eigen::Matrix<local_scalar_t__, -1, 1>(n_record);
      stan::math::fill(k, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(n_record);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 14;
      assign(m, nil_index_list(), add(mu_m, multiply(sigma_m, m_raw)),
        "assigning variable m");
      current_statement__ = 15;
      assign(k, nil_index_list(), add(mu_k, multiply(sigma_k, k_raw)),
        "assigning variable k");
      current_statement__ = 16;
      assign(beta, nil_index_list(),
        add(mu_beta, multiply(sigma_beta, beta_raw)),
        "assigning variable beta");
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        current_statement__ = 11;
        current_statement__ = 11;
        check_greater_or_equal(function__, "m[sym1__]", m[(sym1__ - 1)], 0);}
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_greater_or_equal(function__, "k[sym1__]", k[(sym1__ - 1)], 0);}
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        current_statement__ = 13;
        current_statement__ = 13;
        check_greater_or_equal(function__, "beta[sym1__]",
                               beta[(sym1__ - 1)], 0);}
      {
        current_statement__ = 17;
        lp_accum__.add(normal_lpdf<propto__>(m_raw, 0, 1));
        current_statement__ = 18;
        lp_accum__.add(normal_lpdf<propto__>(mu_m, 40, 30));
        current_statement__ = 19;
        lp_accum__.add(cauchy_lpdf<propto__>(sigma_m, 0, 10));
        current_statement__ = 20;
        lp_accum__.add(normal_lpdf<propto__>(k_raw, 0, 1));
        current_statement__ = 21;
        lp_accum__.add(lognormal_lpdf<propto__>(mu_k, -5, 2));
        current_statement__ = 22;
        lp_accum__.add(lognormal_lpdf<propto__>(sigma_k, -7, 2));
        current_statement__ = 23;
        lp_accum__.add(normal_lpdf<propto__>(beta_raw, 0, 1));
        current_statement__ = 24;
        lp_accum__.add(normal_lpdf<propto__>(mu_beta, 2, 0.5));
        current_statement__ = 25;
        lp_accum__.add(cauchy_lpdf<propto__>(sigma_beta, 0, 2));
        current_statement__ = 26;
        lp_accum__.add(cauchy_lpdf<propto__>(sigma, 0, 5));
        {
          current_statement__ = 27;
          validate_non_negative_index("pdr1", "n", n);
          Eigen::Matrix<local_scalar_t__, -1, 1> pdr1;
          pdr1 = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
          stan::math::fill(pdr1, DUMMY_VAR__);
          
          current_statement__ = 41;
          for (int i = 1; i <= n; ++i) {
            int rec;
            rec = std::numeric_limits<int>::min();
            
            local_scalar_t__ mn;
            mn = DUMMY_VAR__;
            
            local_scalar_t__ exp_ktn;
            exp_ktn = DUMMY_VAR__;
            
            local_scalar_t__ kn;
            kn = DUMMY_VAR__;
            
            local_scalar_t__ betan;
            betan = DUMMY_VAR__;
            
            current_statement__ = 34;
            rec = pat_group_i[(i - 1)];
            current_statement__ = 35;
            mn = m[(rec - 1)];
            current_statement__ = 36;
            kn = k[(rec - 1)];
            current_statement__ = 37;
            exp_ktn = stan::math::exp((-kn * minute[(i - 1)]));
            current_statement__ = 38;
            betan = beta[(rec - 1)];
            current_statement__ = 39;
            assign(pdr1, cons_list(index_uni(i), nil_index_list()),
              (((((dose * mn) * kn) * betan) * exp_ktn) *
                pow((1 - exp_ktn), (betan - 1))), "assigning variable pdr1");
          }
          current_statement__ = 44;
          if (logical_lt(student_t_df, 10)) {
            current_statement__ = 43;
            lp_accum__.add(
              student_t_lpdf<propto__>(pdr, student_t_df, pdr1, sigma));
          } else {
            current_statement__ = 42;
            lp_accum__.add(normal_lpdf<propto__>(pdr, pdr1, sigma));
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_breath_test_1_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> m_raw;
      m_raw = Eigen::Matrix<double, -1, 1>(n_record);
      stan::math::fill(m_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      m_raw = in__.vector(n_record);
      double mu_m;
      mu_m = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      mu_m = in__.scalar();
      current_statement__ = 2;
      mu_m = stan::math::lb_constrain(mu_m, 0);
      double sigma_m;
      sigma_m = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma_m = in__.scalar();
      current_statement__ = 3;
      sigma_m = stan::math::lb_constrain(sigma_m, 0);
      Eigen::Matrix<double, -1, 1> k_raw;
      k_raw = Eigen::Matrix<double, -1, 1>(n_record);
      stan::math::fill(k_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      k_raw = in__.vector(n_record);
      double mu_k;
      mu_k = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      mu_k = in__.scalar();
      current_statement__ = 5;
      mu_k = stan::math::lb_constrain(mu_k, 0);
      double sigma_k;
      sigma_k = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      sigma_k = in__.scalar();
      current_statement__ = 6;
      sigma_k = stan::math::lb_constrain(sigma_k, 0);
      Eigen::Matrix<double, -1, 1> beta_raw;
      beta_raw = Eigen::Matrix<double, -1, 1>(n_record);
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      beta_raw = in__.vector(n_record);
      double mu_beta;
      mu_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      mu_beta = in__.scalar();
      current_statement__ = 8;
      mu_beta = stan::math::lb_constrain(mu_beta, 0);
      double sigma_beta;
      sigma_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      sigma_beta = in__.scalar();
      current_statement__ = 9;
      sigma_beta = stan::math::lb_constrain(sigma_beta, 0);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      sigma = in__.scalar();
      current_statement__ = 10;
      sigma = stan::math::lb_constrain(sigma, 0);
      Eigen::Matrix<double, -1, 1> m;
      m = Eigen::Matrix<double, -1, 1>(n_record);
      stan::math::fill(m, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> k;
      k = Eigen::Matrix<double, -1, 1>(n_record);
      stan::math::fill(k, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(n_record);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        vars__.emplace_back(m_raw[(sym1__ - 1)]);}
      vars__.emplace_back(mu_m);
      vars__.emplace_back(sigma_m);
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        vars__.emplace_back(k_raw[(sym1__ - 1)]);}
      vars__.emplace_back(mu_k);
      vars__.emplace_back(sigma_k);
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        vars__.emplace_back(beta_raw[(sym1__ - 1)]);}
      vars__.emplace_back(mu_beta);
      vars__.emplace_back(sigma_beta);
      vars__.emplace_back(sigma);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 14;
      assign(m, nil_index_list(), add(mu_m, multiply(sigma_m, m_raw)),
        "assigning variable m");
      current_statement__ = 15;
      assign(k, nil_index_list(), add(mu_k, multiply(sigma_k, k_raw)),
        "assigning variable k");
      current_statement__ = 16;
      assign(beta, nil_index_list(),
        add(mu_beta, multiply(sigma_beta, beta_raw)),
        "assigning variable beta");
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        current_statement__ = 11;
        current_statement__ = 11;
        check_greater_or_equal(function__, "m[sym1__]", m[(sym1__ - 1)], 0);}
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_greater_or_equal(function__, "k[sym1__]", k[(sym1__ - 1)], 0);}
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        current_statement__ = 13;
        current_statement__ = 13;
        check_greater_or_equal(function__, "beta[sym1__]",
                               beta[(sym1__ - 1)], 0);}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          vars__.emplace_back(m[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          vars__.emplace_back(k[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          vars__.emplace_back(beta[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> m_raw;
      m_raw = Eigen::Matrix<double, -1, 1>(n_record);
      stan::math::fill(m_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> m_raw_flat__;
        current_statement__ = 1;
        assign(m_raw_flat__, nil_index_list(), context__.vals_r("m_raw"),
          "assigning variable m_raw_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          current_statement__ = 1;
          assign(m_raw, cons_list(index_uni(sym1__), nil_index_list()),
            m_raw_flat__[(pos__ - 1)], "assigning variable m_raw");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      double mu_m;
      mu_m = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      mu_m = context__.vals_r("mu_m")[(1 - 1)];
      double mu_m_free__;
      mu_m_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      mu_m_free__ = stan::math::lb_free(mu_m, 0);
      double sigma_m;
      sigma_m = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma_m = context__.vals_r("sigma_m")[(1 - 1)];
      double sigma_m_free__;
      sigma_m_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma_m_free__ = stan::math::lb_free(sigma_m, 0);
      Eigen::Matrix<double, -1, 1> k_raw;
      k_raw = Eigen::Matrix<double, -1, 1>(n_record);
      stan::math::fill(k_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> k_raw_flat__;
        current_statement__ = 4;
        assign(k_raw_flat__, nil_index_list(), context__.vals_r("k_raw"),
          "assigning variable k_raw_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          current_statement__ = 4;
          assign(k_raw, cons_list(index_uni(sym1__), nil_index_list()),
            k_raw_flat__[(pos__ - 1)], "assigning variable k_raw");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      double mu_k;
      mu_k = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      mu_k = context__.vals_r("mu_k")[(1 - 1)];
      double mu_k_free__;
      mu_k_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      mu_k_free__ = stan::math::lb_free(mu_k, 0);
      double sigma_k;
      sigma_k = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      sigma_k = context__.vals_r("sigma_k")[(1 - 1)];
      double sigma_k_free__;
      sigma_k_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      sigma_k_free__ = stan::math::lb_free(sigma_k, 0);
      Eigen::Matrix<double, -1, 1> beta_raw;
      beta_raw = Eigen::Matrix<double, -1, 1>(n_record);
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_raw_flat__;
        current_statement__ = 7;
        assign(beta_raw_flat__, nil_index_list(),
          context__.vals_r("beta_raw"), "assigning variable beta_raw_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
          current_statement__ = 7;
          assign(beta_raw, cons_list(index_uni(sym1__), nil_index_list()),
            beta_raw_flat__[(pos__ - 1)], "assigning variable beta_raw");
          current_statement__ = 7;
          pos__ = (pos__ + 1);}
      }
      double mu_beta;
      mu_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      mu_beta = context__.vals_r("mu_beta")[(1 - 1)];
      double mu_beta_free__;
      mu_beta_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      mu_beta_free__ = stan::math::lb_free(mu_beta, 0);
      double sigma_beta;
      sigma_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      sigma_beta = context__.vals_r("sigma_beta")[(1 - 1)];
      double sigma_beta_free__;
      sigma_beta_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      sigma_beta_free__ = stan::math::lb_free(sigma_beta, 0);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        vars__.emplace_back(m_raw[(sym1__ - 1)]);}
      vars__.emplace_back(mu_m_free__);
      vars__.emplace_back(sigma_m_free__);
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        vars__.emplace_back(k_raw[(sym1__ - 1)]);}
      vars__.emplace_back(mu_k_free__);
      vars__.emplace_back(sigma_k_free__);
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        vars__.emplace_back(beta_raw[(sym1__ - 1)]);}
      vars__.emplace_back(mu_beta_free__);
      vars__.emplace_back(sigma_beta_free__);
      vars__.emplace_back(sigma_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("m_raw");
    names__.emplace_back("mu_m");
    names__.emplace_back("sigma_m");
    names__.emplace_back("k_raw");
    names__.emplace_back("mu_k");
    names__.emplace_back("sigma_k");
    names__.emplace_back("beta_raw");
    names__.emplace_back("mu_beta");
    names__.emplace_back("sigma_beta");
    names__.emplace_back("sigma");
    names__.emplace_back("m");
    names__.emplace_back("k");
    names__.emplace_back("beta");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_record)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_record)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_record)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_record)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_record)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n_record)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "m_raw" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "mu_m");
    param_names__.emplace_back(std::string() + "sigma_m");
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "k_raw" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "mu_k");
    param_names__.emplace_back(std::string() + "sigma_k");
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "mu_beta");
    param_names__.emplace_back(std::string() + "sigma_beta");
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "m" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "m_raw" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "mu_m");
    param_names__.emplace_back(std::string() + "sigma_m");
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "k_raw" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "mu_k");
    param_names__.emplace_back(std::string() + "sigma_k");
    for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "mu_beta");
    param_names__.emplace_back(std::string() + "sigma_beta");
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "m" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_record; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"m_raw\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"parameters\"},{\"name\":\"mu_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"k_raw\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"parameters\"},{\"name\":\"mu_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"parameters\"},{\"name\":\"mu_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"m\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"transformed_parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"m_raw\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"parameters\"},{\"name\":\"mu_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"k_raw\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"parameters\"},{\"name\":\"mu_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"parameters\"},{\"name\":\"mu_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"m\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"transformed_parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << n_record << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_breath_test_1_namespace::model_breath_test_1;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_breath_test_1_namespace::profiles__;
}
#endif
#endif
