% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/break.R
\name{broken.glm}
\alias{broken.glm}
\title{Create the broken object for glm models}
\usage{
\method{broken}{glm}(model, new_observation, ..., baseline = 0,
  predict.function = stats::predict.glm)
}
\arguments{
\item{model}{a glm model}

\item{new_observation}{a new observation with columns that corresponds to variables used in the model}

\item{...}{other parameters}

\item{baseline}{the origin/baseline for the breakDown plots, where the rectangles start. It may be a number or a character "Intercept". In the latter case the orgin will be set to model intercept.}

\item{predict.function}{function that will calculate predictions out of model (typically \code{predict} or \code{betas})}
}
\value{
an object of the broken class
}
\description{
Create the broken object for glm models
}
\examples{
# example for wine data
wine$qualityb <- factor(wine$quality > 5.5, labels = c("bad", "good"))
modelg <- glm(qualityb~fixed.acidity + volatile.acidity + citric.acid +
              residual.sugar + chlorides + free.sulfur.dioxide +
              total.sulfur.dioxide + density + pH + sulphates + alcohol,
    data=wine, family = "binomial")
new_observation <- wine[1,]
br <- broken(modelg, new_observation)
logit <- function(x) exp(x)/(1+exp(x))
plot(br, logit)

# example for HR_data
model <- glm(left~., data = HR_data, family = "binomial")
explain_1 <- broken(model, HR_data[1,])
explain_1
plot(explain_1)
plot(explain_1, trans = function(x) exp(x)/(1+exp(x)))

explain_2 <- broken(model, HR_data[1,], predict.function = betas)
explain_2
plot(explain_2, trans = function(x) exp(x)/(1+exp(x)))
}
