% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glob.R
\name{glob}
\alias{glob}
\title{Brace and Wildcard expansion on file paths}
\usage{
glob(paths, ..., engine = getOption("bracer.engine", NULL))
}
\arguments{
\item{paths}{character vector of patterns for relative or absolute filepaths.}

\item{...}{Passed to \code{Sys.glob}}

\item{engine}{If \code{'r'} use a pure R parser.
If \code{'v8'} use the 'braces' Javascript parser via the suggested V8 package.
If \code{NULL} use \code{'v8'} if \code{'V8'} package detected else use \code{'r'};
in either case send a \code{message()} about the choice
unless \verb{getOption(bracer.engine.inform')} is \code{FALSE}.}
}
\description{
\code{glob} is a wrapper around \code{Sys.glob} that uses
\code{expand_braces} to support both brace and wildcard
expansion on file paths.
}
\examples{
  dir <- system.file("R", package="bracer")
  path <- file.path(dir, "*.{R,r,S,s}")
  glob(path)
}
