% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRII.R
\name{infactor_or2}
\alias{infactor_or2}
\title{Inefficiency Factor for Ordinal Model
with 3 outcomes}
\usage{
infactor_or2(x, beta, sigma, autocorrelationCutoff = 0.05)
}
\arguments{
\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{beta}{Gibbs draw of coefficients of dimension \eqn{(k x nsim)}.}

\item{sigma}{Gibbs draw of scale factor.}

\item{autocorrelationCutoff}{Cut-off to identify the number of lags.}
}
\value{
Returns a list with components
\itemize{
\item{\code{inefficiencyBeta}: }{a vector with inefficiency factor for each \eqn{\beta}.}
\item{\code{inefficiencySigma}: }{a vector with inefficiency factor for each \eqn{\sigma}.}
}
}
\description{
This function calculates the inefficiency factor from the MCMC draws
of \eqn{(\beta, \sigma)} for an ordinal model with 3 outcomes. The
inefficiency factor is calculated using the batch-means method.
}
\details{
Calculates the inefficiency factor of \eqn{(\beta, \sigma)} using the batch-means
method.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
k <- dim(x)[2]
output <- quantreg_or2(y = y, x = x, B0 = 10*diag(k),
mcmc = 50, p = 0.25)
beta <- output$beta
sigma <- output$sigma

inefficiency <- infactor_or2(x, beta, sigma, 0.5)

# Summary of Inefficiency Factor:
#            Inefficiency
# beta_0       1.0977
# beta_1       1.5840
# beta_2       1.5383
# sigma        2.8946

}
\references{
Greenberg, E. (2012). “Introduction to Bayesian Econometrics.”
 Cambridge University Press, Cambridge.
}
\seealso{
pracma, \link[stats]{acf}
}
