% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data75j4}
\alias{data75j4}
\title{data75j4
Data with 500 observations for \eqn{p = 0.75} with 4 outcomes}
\usage{
data(data75j4)
}
\value{
Returns a list with components
\itemize{
\item{\code{x}: }{a matrix of covariates.}
\item{\code{y}: }{a matrix of ordinal outcomes.}
}
}
\description{
data75j4
Data with 500 observations for \eqn{p = 0.75} with 4 outcomes
}
\details{
Generates 500 observations for the simulation study at the \eqn{75^{th}}
quantile. The specifications are \eqn{\beta = (-4, 5, 6)}, $X ~ Unif(0, 1)$,
and \eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.75}).

The errors are generated from an asymmetric Laplace distribution
by using its normal–exponential mixture formulation.

The continuous value are classified into 4 categories using the
cut-points (0, 2, 4).
}
\references{
Kozumi, H. and Kobayashi, G. (2011). “Gibbs Sampling Methods for Bayesian Quantile Regression.”
 Journal of Statistical Computation and Simulation, 81(11): 1565–1578.
}
\seealso{
\link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
}
\keyword{datasets}
