% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{BFc}
\alias{BFc}
\title{Bayes Factors}
\usage{
BFc(object, hypothesis, type = "anchor")
}
\arguments{
\item{object}{an object used to select a method.}

\item{hypothesis}{the inequality constrained hypothesis to test.}

\item{type}{type of hypothesis to test c("anchor", "isotropic").}
}
\description{
\code{BF} gives Bayes factors for inequality constrained hypotheses on
circular mean differences.
}
\details{
the methods \link[bpnreg]{BFc.bpnr} and
  \link[bpnreg]{BFc.bpnme} have their own help page.
}
\examples{
library(bpnreg)
fit.Motor <- bpnr(pred.I = Phaserad ~ 1 + Cond, data = Motor,
its = 100, burn = 10, n.lag = 3)
BFc(fit.Motor, hypothesis = "Condsemi.imp < Condimp")

}
