% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proposalLambda.R
\name{CalculateProposalLambda}
\alias{CalculateProposalLambda}
\title{CalculateProposalLambda}
\usage{
CalculateProposalLambda(hparam, thetaYList, CxyList, constraint, m, p,
  qVec)
}
\arguments{
\item{hparam}{hparam}

\item{thetaYList}{thetaYList}

\item{CxyList}{CxyList}

\item{constraint}{constraint}

\item{m}{the number of clusters}

\item{p}{the number of features}

\item{qVec}{the vector of the number of factors in each clusters}
}
\value{
calculated lambda for proposal function
}
\description{
CalculateProposalLambda
}
\examples{
sample_data = "https://raw.githubusercontent.com/lzyacht/bpgmm-examples/master/data/sampleData.csv"
X = utils::read.table(sample_data, header = TRUE, sep = ',')
X = as.matrix(X)
nsim = 1
burn = 20
n = ncol(X)
p = nrow(X)
m = 2
qVec = rep(3,m)
qnew = 3
delta = 2
ggamma = 2
dVec = c(1,1,1)
sVec = c(1,1,1)
constraint = c(1,1,1)

hparam = new("Hparam", alpha1=1, alpha2=2, bbeta=3, delta=4, ggamma=5)
muBar = apply(X, MARGIN = 1, FUN = mean)
ZOneDim = kmeans(x = t(X), centers = m)$cluster
thetaYList = generatePriorThetaY(m, n, p, muBar, hparam, qVec, ZOneDim, constraint)

\donttest{
url <- paste0("https://github.com/lzyacht/bpgmm-examples/",
"blob/master/data/CalculateProposalLambda.RData?raw=true")
download.file(url, destfile= "CalculateProposalLambda.RData", mode = "wb")
load("CalculateProposalLambda.RData")
CalculateProposalLambda(hparam, thetaYList, CxyList, constraint, m, p, qVec)
}

}
