% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internalFunctions.R
\name{identifyNegBinPars}
\alias{identifyNegBinPars}
\title{Determine the parameters of the best-fit negative binomial distribution for a given confidence interval.}
\usage{
identifyNegBinPars(
  qLow,
  qUpp,
  alpha = 0.05,
  initPars = c(10, 0.5),
  maxiter = 1000
)
}
\arguments{
\item{qLow}{The observed lower quantile.}

\item{qUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}

\item{initPars}{A vector of length 2 giving the initial parameter values to start the optimisation; defaults to c(10,0.5).}

\item{maxiter}{Maximum number of iterations for \code{optim}. Defaults to 1e3. Set to higher values if convergence problems are reported.}
}
\value{
A vector of length 2 giving the 2 parameters size and prob for use with rnbinom/dnbinom/pnbinom/qnbinom.
}
\description{
Finds the best-fit negative binomial distribution parameters for a given confidence interval and returns the size, prob parameters.
}
\seealso{
\code{\link{ssNegBinPars}}, \code{\link{optim}}, \code{\link{dnbinom}}
}
