% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{barycentric_rational}
\alias{barycentric_rational}
\title{Barycentric Rational Interpolation}
\usage{
barycentric_rational(x, y, order = 3)
}
\arguments{
\item{x}{Numeric vector of data points (abscissas).}

\item{y}{Numeric vector of data values (ordinates).}

\item{order}{Integer representing the approximation order of the interpolator, defaults to 3.}
}
\value{
An object of class \code{barycentric_rational_interpolator} with methods:
\itemize{
\item \code{spline(xi)}: Evaluate the interpolator at point \code{xi}.
\item \code{prime(xi)}: Evaluate the derivative of the interpolator at point \code{xi}.
}
}
\description{
Constructs a barycentric rational interpolator given data points.
}
\examples{
x <- c(0, 1, 2, 3)
y <- c(1, 2, 0, 2)
order <- 3
interpolator <- barycentric_rational(x, y, order)
xi <- 1.5
interpolator$interpolate(xi)
interpolator$derivative(xi)
}
