% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapairy_distribution.R
\name{mapairy_distribution}
\alias{mapairy_distribution}
\alias{mapairy_pdf}
\alias{mapairy_lpdf}
\alias{mapairy_cdf}
\alias{mapairy_lcdf}
\alias{mapairy_quantile}
\title{Map-Airy Distribution Functions}
\usage{
mapairy_pdf(x, location = 0, scale = 1)

mapairy_lpdf(x, location = 0, scale = 1)

mapairy_cdf(x, location = 0, scale = 1)

mapairy_lcdf(x, location = 0, scale = 1)

mapairy_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{x}{quantile}

\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Map-Airy distribution.
}
\examples{
# Distribution only available with Boost version 1.87.0 or later.
\dontrun{
# Map-Airy distribution with location 0 and scale 1
  mapairy_pdf(3)
  mapairy_lpdf(3)
  mapairy_cdf(3)
  mapairy_lcdf(3)
  mapairy_quantile(0.5)
}
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/dist_ref/dists/mapairy_dist.html}{Boost Documentation} for more details on the mathematical background.
}
