% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.subdatasets.R
\name{create.subdatasets}
\alias{create.subdatasets}
\title{Creates sub datasets.}
\usage{
create.subdatasets(data.to.work, variables, dataset.name)
}
\arguments{
\item{data.to.work}{is a dataset from which a new sub dataset will be extracted.}

\item{variables}{is the list of variables from the dataset to build the new one.}

\item{dataset.name}{is the name of new dataset.}
}
\value{
A new sub dataset.
}
\description{
Receives a dataset and build a new sub dataset.
}
\details{
This function receives a dataset, a list with the name of some variables of this dataset, and a name to save the new dataset as parameter. Then the function builds a new dataset with these variables and return it.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
# load datasets from package
data.to.work <-dataQualiN
# Set variables to create a new dataset
variables <- c( "A","S","L","E","D")
# Set the new dataset name
dataset.name <- "data.work.new"
# Creates the subdataset
create.subdatasets(data.to.work, variables, dataset.name)
}
\author{
Elias Carvalho
}

