% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalization.R
\name{penInit}
\alias{penInit}
\title{Initializing penalization matrix}
\usage{
penInit(
  bnnames,
  pfbase = 1,
  intpf = pfbase,
  intlist = NULL,
  intsame = 1,
  usescore = FALSE
)
}
\arguments{
\item{bnnames}{object of class bnInfo; see \link{bnInfo}}

\item{pfbase}{a numeric value more or equal to 1, base penalization factor; 1 by default (no penalization)}

\item{intpf}{(optional) a numeric value more or equal to 1, this value will be used to penalize interactions from 'intlist'}

\item{intlist}{(optional) a matrix or data frame containing a list of interactions and optionally their scores; 2 columns are necessary 'gene1' and 'gene2'}

\item{intsame}{penalization factor for edges connecting the same genes}

\item{usescore}{(logical) when TRUE, interactions score from column 'score' of the parameter 'intlist' will be used to define penalization factor}
}
\value{
returns a square matrix containing edge specific penalization factors
}
\description{
This function can be used to initialize a penalization matrix for bnclustOmics clustering
}
\author{
Polina Suter
}
