% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcew_api.R
\name{qcew_api}
\alias{qcew_api}
\title{Request data from the Quarterly Census of Employment and Wages.}
\usage{
qcew_api(year = 2018, qtr = "a", slice = NULL, sliceCode = NULL, ...)
}
\arguments{
\item{year}{These data begin in 2012 and go to the most recent complete quarter. The argument can be entered
as an integer or a character. The default is 2012.}

\item{qtr}{Quarter: This can be any integer between 1 and 4, or "A" for annual. The argument can be entered
as an integer or a character. The default is 1, which returns the first quarter.}

\item{slice}{The slice should be one of the three data slices offered by the API; "industry", "area", or "size."}

\item{sliceCode}{The slice codes depend on what slice you select. For example, if you select the "area" slice,
your \code{sliceCode} should be a FIPS code. If you select "industry," your \code{sliceCode} should be a NIACS code.
There are three internal data sets containing acceptable slice codes to help with selections; \code{blscrapeR::niacs}
contains industry codes and descriptions, \code{blscrapeR::area_titles} contains FIPS codes and area descriptions,
and \code{blscrapeR::size_titles} contains industry size codes. These codes can be used for the \code{sliceCode} argument.}

\item{...}{additional arguments}
}
\description{
Return data from the QCEW API. This is separate from the main BLS API and returns quarterly data
sliced by industry, area or size. Industry is identified by NIACS code and area is identified by FIPS code.
A key is not required for the QCEW API.
}
\examples{

# A request for the employment levels and wages for NIACS 5112: Software Publishers.
dat <- qcew_api(year=2017, qtr="a", slice="industry", sliceCode=5112)


}
\seealso{
\url{https://data.bls.gov/cew/doc/access/csv_data_slices.htm}
}
\keyword{api}
\keyword{bls}
\keyword{cpi}
\keyword{economics}
\keyword{inflation}
\keyword{unemployment}
