% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous.R
\name{vb_continuous}
\alias{vb_continuous}
\title{Continuous voting bloc analysis}
\usage{
vb_continuous(
  data,
  data_density = data,
  data_turnout = data,
  data_vote = data,
  indep,
  dv_vote3,
  dv_turnout,
  weight = NULL,
  min_val = NULL,
  max_val = NULL,
  n_points = 100,
  boot_iters = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{default data.frame to use as the source for
density, turnout, and vote choice data.}

\item{data_density}{data.frame of blocs' composition/density data. Must
include any columns named by \code{indep} and \code{weight}.}

\item{data_turnout}{data.frame of blocs' turnout data. Must include any
columns named by \code{dv_turnout}, \code{indep} and
\code{weight}.}

\item{data_vote}{data.frame of blocs' vote choice data. Must include any
columns named by \code{dv_vote3}, \code{indep}, and \code{weight}.}

\item{indep}{string, column name of the independent variable defining
discrete voting blocs.}

\item{dv_vote3}{string, column name of the dependent variable in \code{data_vote}, coded as
follows: -1 for Democrat vote choice, 0 for no or third-party vote, 1 for
Republican vote choice.}

\item{dv_turnout}{string, column name of the dependent variable flagging
voter turnout in \code{data_turnout}. That column must be coded 0 =  no vote, 1 = voted.}

\item{weight}{optional string naming the column of sample weights.}

\item{min_val}{numeric vector of the same length as \code{indep}, Lower bound for the density estimation of each respective \code{indep}. See
[estimate_density].}

\item{max_val}{numeric vector of the same length as \code{indep}, Upper bound for the density estimation of each respective \code{indep}. See
[estimate_density].}

\item{n_points}{scalar, number of points at which to estimate density. See
[estimate_density].}

\item{boot_iters}{integer, number of bootstrap iterations for uncertainty
estimation. The default \code{FALSE} is equivalent to 0 and does not estimate
uncertainty.}

\item{verbose}{logical, whether to print iteration number.}

\item{...}{further arguments to pass to \link[ks]{kde} for density estimation.}
}
\value{
a \code{vbdf} data.frame with columns for the resample, bloc variable,
and, for each resample-bloc combination, four estimates:
probability density, turnout, Republican vote choice conditional on turnout,
and net Republican votes.
}
\description{
Define voting blocs along a \strong{continuous} variable and estimate their
partisan vote contributions.
}
