% Generated by roxygen2 (4.0.2): do not edit by hand
\name{efficiencies}
\alias{efficiencies}
\title{Efficiencies of pairwise differences}
\usage{
efficiencies(Design)
}
\arguments{
\item{Design}{A design data frame generated by \code{\link[blocksdesign]{blocks}}}
}
\value{
\item{Efficiencies}{List of treatments efficiency matrices for all pairwise differences for each stratum of the design}
}
\description{
\code{efficiencies} function tabulates the efficiencies of pairwise treatment difference for each stratum of a design
}
\details{
Tabulates the efficiency of pairwise treatment difference for each statum of any design built by the \code{blocks} function.
 The tables provide detailed information such as the minimum efficiency of all possible treatment comparisons.
 For equi-replicate designs, the harmonic mean of the pairwise efficiency factors  will equal the A-efficiency factor,
  as calculated by the \code{blocks} function.
}
\examples{
# 4 replicates of 50 treatments in complete randomized blocks
efficiencies(blocks(treatments=50,replicates=4,blocklevels=c(4,5))$Design)
}

