% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxlps_baseline.R
\name{coxlps.baseline}
\alias{coxlps.baseline}
\title{Extract estimated baseline quantities from a fit with coxlps.}
\usage{
coxlps.baseline(object, time = NULL, compute.cred = TRUE, cred.int = 0.95,
                verbose = TRUE)
}
\arguments{
\item{object}{An object of class \code{coxlps}.}

\item{time}{A vector of time values on which to compute the estimated
baseline quantities. Each component of \code{time} must be between 0 and
the largest observed follow-up time. If time is \code{NULL} (the default),
then only the baseline median lifetime (if available) is computed.}

\item{compute.cred}{Should the credible intervals be computed? Default is
TRUE.}

\item{cred.int}{The level for an approximate pointwise credible interval
to be computed for the baseline hazard and survival curves. Default
is 0.95.}

\item{verbose}{Should the table of estimated values be printed to console?
Default is TRUE.}
}
\value{
A list with the following components:

  \item{fit.time}{A matrix with point and set estimates of
  the baseline hazard and survival curves for values provided in \code{time}.
  Only available if \code{time} is not \code{NULL}. Column \emph{Time}
  summarizes the provided values in \code{time}. Columns named \emph{h0},
  \emph{S0}, are the point estimates of the baseline hazard and baseline
  survival respectively. \emph{low} and \emph{up} give the lower and
  upper bound respectively of the approximate pointwise credible interval.}

  \item{median.lifetime \verb{ }}{The estimated baseline median lifetime.}

  \item{cred.int \verb{ }}{The chosen level to construct credible intervals.}
}
\description{
The routine takes as input an object of class \code{coxlps} and computes
point estimates and credible intervals for the baseline hazard and survival
on a user-specified time vector.
}
\examples{

## Simulate survival data
set.seed(2)
betas <- c(0.15, 0.82, 0.41) # Regression coefficients
data <- simsurvdata(a = 1.8, b = 2, n = 300, betas = betas, censperc = 15)
simdat <- data$survdata

# Fit model
fit <- coxlps(Surv(time, delta) ~ x1 + x2 + x3, data = simdat, K = 20)
coxlps.baseline(fit, time = seq(0, 2, by = 0.5), cred.int = 0.90)

}
\seealso{
\code{\link{coxlps}}, \code{\link{coxlps.object}}
}
\author{
Gressani Oswaldo \email{oswaldo_gressani@hotmail.fr}.
}
