% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMixtureSummaries.R
\name{SingVarIntSummaries}
\alias{SingVarIntSummaries}
\title{Single Variable Interaction Summaries}
\usage{
SingVarIntSummaries(
  fit,
  y = NULL,
  Z = NULL,
  X = NULL,
  which.z = 1:ncol(Z),
  qs.diff = c(0.25, 0.75),
  qs.fixed = c(0.25, 0.75),
  method = "approx",
  sel = NULL,
  z.names = colnames(Z),
  ...
)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{which.z}{vector indicating which variables (columns of \code{Z}) for which the summary should be computed}

\item{qs.diff}{vector indicating the two quantiles at which to compute the single-predictor risk summary}

\item{qs.fixed}{vector indicating the two quantiles at which to fix all of the remaining exposures in \code{Z}}

\item{method}{method for obtaining posterior summaries at a vector of new points. Options are "approx" and "exact"; defaults to "approx", which is faster particularly for large datasets; see details}

\item{sel}{logical expression indicating samples to keep; defaults to keeping the second half of all samples}

\item{z.names}{optional vector of names for the columns of \code{z}}

\item{...}{other arguments to pass on to the prediction function}
}
\description{
Compare the single-predictor health risks when all of the other predictors in Z are fixed to their a specific quantile to when all of the other predictors in Z are fixed to their a second specific quantile.
}
\details{
\itemize{
  \item If \code{method == "approx"} then calls the function \code{\link{ComputePostmeanHnew.approx}}. In this case, the argument \code{sel} defaults to the second half of the MCMC iterations.
  \item If \code{method == "exact"} then calls the function \code{\link{ComputePostmeanHnew.exact}}. In this case, the argument \code{sel} defaults to keeping every 10 iterations after dropping the first 50\% of samples, or if this results in fewer than 100 iterations, than 100 iterations are kept
}
For guided examples and additional information, go to \url{https://jenfb.github.io/bkmr/overview.html}
}
