% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bittermelon-package.R
\docType{package}
\name{bittermelon}
\alias{bittermelon}
\alias{bittermelon-package}
\title{bittermelon: Monochrome Bitmap Font Tools}
\description{
\if{html}{\figure{logo.png}{options: align='right' alt='logo' width='120'}}

Provides functions for creating and modifying bitmaps with special emphasis on bitmap fonts and their glyphs.  Provides native read/write support for the 'hex' and 'yaff' bitmap font formats and if 'Python' is installed can also read/write several more bitmap font formats using an embedded version of 'monobit'.
}
\section{Package options}{

The following \code{bittermelon} option may be set globally via \code{\link[base:options]{base::options()}}:
\describe{
\item{bittermelon.px}{Set new default \code{px} argument value for
\code{\link[=format.bm_bitmap]{format.bm_bitmap()}} and \code{\link[=print.bm_bitmap]{print.bm_bitmap()}}.
If unset both functions default to \code{px_unicode} but
some may prefer \code{px_ascii} which is an ASCII alternative.}
\item{bittermelon.fg}{Set new default \code{fg} argument value for
\code{\link[=format.bm_bitmap]{format.bm_bitmap()}} and \code{\link[=print.bm_bitmap]{print.bm_bitmap()}}.}
\item{bittermelon.bg}{Set new default \code{bg} argument value for
\code{\link[=format.bm_bitmap]{format.bm_bitmap()}} and \code{\link[=print.bm_bitmap]{print.bm_bitmap()}}.}
\item{bittermelon.compress}{Set new default \code{compress} argument value for
\code{\link[=format.bm_bitmap]{format.bm_bitmap()}} and \code{\link[=print.bm_bitmap]{print.bm_bitmap()}}.}
}
The following \code{findpython} option may also be of interest:
\describe{
\item{python_cmd}{Explicitly set path to python binary to use with \code{\link[=read_monobit]{read_monobit()}}
or \code{\link[=write_monobit]{write_monobit()}}.  This is actually the appropriate global option
for \code{\link[findpython:find_python_cmd]{findpython::find_python_cmd()}}.}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://trevorldavis.com/R/bittermelon/}
  \item Report bugs at \url{https://github.com/trevorld/bittermelon/issues}
}

}
\author{
\strong{Maintainer}: Trevor L Davis \email{trevor.l.davis@gmail.com}

Other contributors:
\itemize{
  \item Rob Hagemans (Author of included 'monobit' library) [copyright holder]
  \item Frederic Cambus (Author of included 'Spleen' font) [copyright holder]
}

}
\keyword{internal}
