% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Array2DF.R
\name{Array2DF}
\alias{Array2DF}
\title{Convert bipartite-style arrays to dataframe}
\usage{
Array2DF(Array, PrimaryLab = "Primary", SecondaryLab = "Secondary",
  SiteNames = NULL)
}
\arguments{
\item{Array}{An array of bipartite format}

\item{PrimaryLab}{Label for the primary level of the bipartite web, e.g. 'Plants'}

\item{SecondaryLab}{Label for the secondary level of the bipartite web, e.g. 'Pollinators'}

\item{SiteNames}{Vector of names for the different sires (array slices). By default takes names of input array if they exist.}
}
\value{
A data.frame where the first column is the primary interactor, the second the secondary interactor and subsequent named columns detail the link strengths
}
\description{
Returns a data frame in the format internally required for bipartiteD3 where the first
two columns list the interacting species, and subsequent columns list the link strengths in each site.
}
\details{
Array2DF expects an array of multiple bipartite webs as may be created by the webs2array() function in bipartite.
This structure includes row and column names to indicate the species, and a named third dimension giving
the names of each of the sites

Note an array of this format can be passed directly to bipartite_D3 since it will test for an array and apply Array2DF() anyway.
}
\examples{

\dontrun{
data(Safariland, vazquenc, package='bipartite')
allin1 <- bipartite::webs2array(Safariland, vazquenc)
Array2DF(allin1)
}
}
