% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.2p.2n.R
\name{power.2p.2n}
\alias{power.2p.2n}
\title{Calculate the Power and Sample Size for 2 Independent Proportions.}
\usage{
power.2p.2n(
  p1,
  p2,
  n1 = NULL,
  n2 = NULL,
  nratio = NULL,
  power = NULL,
  alternative = "two.sided",
  conf.level = 0.95,
  continuity = FALSE
)
}
\arguments{
\item{p1}{Numeric, the proportion for the first group.}

\item{p2}{Numeric, the proportion for the second group.}

\item{n1}{Numeric, the sample size for the first group.}

\item{n2}{Numeric, the sample size for the second group.}

\item{nratio}{Numeric, the sample size ratio (n2 / n1) for unbalanced
designs. Default is 1 when calculating sample sizes n1 and n2.}

\item{power}{Numeric, the desired power (1 - beta). Default is 0.8 when
calculating sample sizes n1 and n2 and when calculating n2 given n1.}

\item{alternative}{Character, the type of alternative hypothesis.
Options are 'two.sided' (default) or 'one.sided'.}

\item{conf.level}{Numeric, the confidence level (1 - alpha). Default is 0.95.}

\item{continuity}{Logical, indicating whether the continuity correction
should be applied. Default is FALSE.}
}
\value{
A list with the following components:
\itemize{
\item \code{n}: Total sample size (n1 + n2).
\item \code{n1}: Sample size for the first group.
\item \code{n2}: Sample size for the second group.
\item \code{power}: The estimated power.
\item \code{nratio}: The sample size ratio (n2 / n1), if applicable.
}
}
\description{
This function calculates
\enumerate{
\item The power given independent proportions p1 and p2, the sample sizes for
the two groups, the confidence level and the alternative hypothesis.
\item The required sample size given independent proportions p1 and p2, the
desired power, the confidence level and the alternative hypothesis.
\item The required sample sizes n1 and n2 given the desired power, a sample
size ratio n2/n1 (unbalanced designs), the confidence level and the
alternative hypothesis.
\item The sample size for the second group given independent proportions
p1 and p2, the sample size for the first group (unbalanced designs), the
desired power, the confidence level and the alternative hypothesis.
}
}
\examples{
# Calculate the power for independent proportions given the sample sizes
power.2p.2n(p1 = 0.45, p2 = 0.6, n1 = 260, n2 = 130)

# Calculate the sample size for independent proportions (default power = 0.8)
power.2p.2n(p1 = 0.45, p2 = 0.6)

# Calculate n1 and n2 for independent proportions with ratio n2/n1
power.2p.2n(p1 = 0.44, p2 = 0.6, nratio = 2)

# Calculate n2 given n1 for independent proportions
power.2p.2n(p1 = 0.44, p2 = 0.6, n1 = 108)
}
\references{
Levin, B., & Chen, X. (1999). Is the one-half continuity correction used
once or twice to derive a well-known approximate sample size formula to
compare two independent binomial distributions?. \emph{The American Statistician},
53(1), 62-66. https://doi.org/10.1080/00031305.1999.10474431.
Fleiss, J. L., Levin, B., & Paik, M. C. (2013). \emph{Statistical methods for
rates and proportions}. John Wiley & Sons.
}
