% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{models_linear}
\alias{models_linear}
\alias{fit_linear}
\alias{plot_linear}
\alias{interpolate_linear}
\title{Linear model functions.}
\usage{
fit_linear(x, y)

plot_linear(x, y)

interpolate_linear(y, model)
}
\arguments{
\item{x}{The x coordinates of the points.}

\item{y}{The y coordinates of the points.}

\item{model}{The line model.}
}
\value{
\itemize{
\item \code{fit_linear}: The line model.
\item \code{plot_linear}: The plot.
\item \code{interpolate_linear}: The calculated x values.
}
}
\description{
Use these functions to calculate a linear model from data, plot the model and
use it to calculate x-values from the model data and y-values (inverse
function).

Those function are intended to be used in \link{set_calc_concentrations} /
\link{sets_read} to be applied to the calibrators (\code{fit_linear}) and interpolate
concentrations from the raw values (\code{interpolate_linear}). Use \code{plot_linear}
to visually inspect goodness of fit.
\itemize{
\item \code{fit_linear}: Calculate a linear model from x and y.
\item \code{plot_linear}: Draw the plot for the model that can be calculated with
\code{fit_linear}. Uses \link[ggplot2:ggplot]{ggplot2::ggplot} if available.
\item \code{interpolate_linear}: Inverse \code{fit_linear} using \code{model} and calculate x
values from y values.
}
}
\examples{
# generate data
x <- c(1, 3, 4, 7)
y_known <- c(3.5, 6.5, 8, 12.5)  # x is known for these values
y_unknown <- c(5, 9.5, 11)       # we will calculate x for those

model <- fit_linear(x = x, y = y_known)
model

plot_linear(x = x, y = y_known)

interpolate_linear(y = y_unknown, model)

rm(x, y_known, y_unknown, model)

}
\seealso{
\link{set_calc_concentrations}, \link{sets_read}, \link{models_lnln}
}
