% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sizeFilter.R
\name{sizeFilter}
\alias{sizeFilter}
\title{Size-based exclusion}
\usage{
sizeFilter(centers, coordinates, lowerlimit = "auto", upperlimit = "auto")
}
\arguments{
\item{centers}{center coordinates of objects (value|mx|my|size data frame)}

\item{coordinates}{all coordinates of the objects (x|y|value data frame)}

\item{lowerlimit}{smallest accepted object size (numeric / 'auto')}

\item{upperlimit}{highest accepted object size (numeric / 'auto')}
}
\value{
list of 2 objects:
\itemize{
\item Remaining centers after discarding according to size.
\item Remaining coordinates after discarding according to size.
}
}
\description{
Takes the size of the objects in an image and discards objects based
on a lower and an upper size limit.
(Input can be obtained by \code{\link[biopixR]{objectDetection}} function)
}
\details{
The \code{\link[biopixR]{sizeFilter}} function is designed to filter
detected objects based on their size, either through automated detection or
user-defined limits. The automated detection of size limits uses the 1.5*IQR
method to identify and remove outliers. This approach is most effective when
dealing with a large number of objects, (typically more than 50), and when
the sizes of the objects are relatively uniform. For smaller samples or when
the sizes of the objects vary significantly, the automated detection may not
be as accurate, and manual limit setting is recommended.
}
\examples{
res_objectDetection <- objectDetection(
  beads,
  method = 'edge',
  alpha = 1,
  sigma = 0
  )
res_sizeFilter <- sizeFilter(
  centers = res_objectDetection$centers,
  coordinates = res_objectDetection$coordinates,
  lowerlimit = 50, upperlimit = 150
  )
changePixelColor(
  beads,
  res_sizeFilter$coordinates,
  color = "darkgreen",
  visualize = TRUE
  )
}
