% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sequence_io.R
\name{read_genome}
\alias{read_genome}
\title{Read the genome of a given Organism}
\usage{
read_genome(file, format, ...)
}
\arguments{
\item{file}{a character string specifying the path to the file storing the genome.}

\item{format}{a character string specifying the file format used to store the genome, e.g. "fasta", "gbk".}

\item{...}{additional arguments that are used by the seqinr::read.fasta() function.}
}
\value{
A data.table storing the gene id in the first column and the corresponding
sequence as string in the second column.
}
\description{
This function reads an organism specific genome stored in a defined file format.
}
\details{
The \code{read.genome} function takes a string specifying the path to the genome file
of interest as first argument.

It is possible to read in different genome file standards such as \emph{fasta} or \emph{genebank}.
Genomes stored in fasta files can be downloaded from http://ensemblgenomes.org/info/genomes.
}
\examples{
\dontrun{
# reading a genome stored in a fasta file
Ath.genome <- read.genome(system.file('seqs/ortho_thal_cds.fasta', package = 'orthologr'),
                           format = "fasta")
}
}
\author{
Hajk-Georg Drost
}

