% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/information_gain.R
\name{calc_ig_single}
\alias{calc_ig_single}
\title{Calculate IG for single feature}
\usage{
calc_ig_single(feature, target_b, len_target, pos_target, ES)
}
\arguments{
\item{feature}{feature vector.}

\item{target_b}{target in bits (as per \code{\link[bit]{as.bit}}).}

\item{len_target}{length of target vector.}

\item{pos_target}{number of positive cases in target vector.}

\item{ES}{numeric value of target entropy.}
}
\value{
a single numeric value - information gain in nats.
}
\description{
Computes information gain of single feature and target vector.
}
\details{
Input looks strange, but the function was designed to be as fast
as possible subroutine of \code{\link{calc_ig}} and generally should not be directly
called by user.
}
\examples{
tar <- sample(0L:1, 100, replace = TRUE)
feat <- sample(0L:1, 100, replace = TRUE)
prop <- c(100 - sum(tar), sum(tar))/100
entr <- - sum(prop*log(prop))
library(bit) #used to code vector as bit
calc_ig_single(feat, as.bit(tar), 100, sum(tar), entr)
}

