% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbHeader-class.R
\docType{class}
\name{gbLocus-class}
\alias{gbLocus-class}
\alias{.gbLocus}
\alias{gbLocus-class}
\title{Generator object for the \code{"gbLocus"} reference class}
\arguments{
\item{...}{List of arguments (see NOTE)}
}
\description{
Generator object for the \code{"gbLocus"} reference class

Generates an object representing a GenBank LOCUS line.
}

\note{
Arguments to the \code{#new} method must be named arguments:
\itemize{
\item{lnm}{ Locus name; stored in the \code{lnm} field. }
\item{len}{ Sequence lenght; stored in the \code{len} field. }
\item{mtp}{ Molecule type; stored in the \code{mtp} field). }
\item{div}{ Genbank division; stored in the \code{div} field. }
\item{top}{ Topology; stored in the \code{top} field. }
\item{mdt}{ Modification date; stored in the \code{mdt} field. }
\item{cdt}{ Create date; stored in the \code{cdt} field. }
}
}
\section{Methods}{

\describe{
 \item{\code{#new(lnm, len, mtp, div, top, mdt, cdt)}:}{
   Create a new \code{\linkS4class{gbLocus}} object}
 \item{\code{#to_string()}:}{
   Create a string representation of a GenBank LOCUS field. }
}
}

\section{Fields}{

\describe{
 \item{\code{lnm}:}{ Locus name. Usually the accession number. }
 \item{\code{len}:}{ Sequence length; In bp or aa, depending on \code{mtp}. }
 \item{\code{mtp}:}{ Molecule type; \emph{NA}, \emph{DNA}, \emph{RNA},
     \emph{tRNA} (transfer RNA), \emph{rRNA} (ribosomal RNA), \emph{mRNA}
     (messenger RNA), \emph{uRNA} (small nuclear RNA), or \emph{AA}
     (protein sequence). RNAs can be prefixes ss- (single-stranded),
     ds- (double-stranded), or ms- (mixed-stranded)}
\item{\code{div}:}{ Genbank division. }
\item{\code{top}:}{ Topology; linear, circular, or missing (\code{NA}). }
\item{\code{mdt}:}{ Modification date. }
\item{\code{cdt}:}{ Create date. }
}
}

\section{Extends}{
 All reference classes extend and inherit methods from
   \code{"\linkS4class{envRefClass}"}.
}

\examples{
showClass("gbLocus")
}
\keyword{classes}
\keyword{internal}
