% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_fitting.R
\name{calculate_model_stats}
\alias{calculate_model_stats}
\title{Calculate model statistics}
\usage{
calculate_model_stats(
  model_data,
  fit_coeffs_vec,
  glm_results = NULL,
  fit_algorithm = NULL,
  response = "yield",
  link = c("identity", "log"),
  type = c("theory", "raw"),
  Y = NULL,
  mu = NULL,
  n = NULL,
  npar = NULL,
  genome_factor = NULL,
  calc_type = c("fitting", "estimation")
)
}
\arguments{
\item{model_data}{Data of the model.}

\item{fit_coeffs_vec}{Vector of fitting coefficients.}

\item{glm_results}{Results of glm.}

\item{fit_algorithm}{String of the algorithm used.}

\item{response}{Type of response.}

\item{link}{Fit link.}

\item{type}{Theoretical or raw glm model statistics.}

\item{Y}{Y response (required in constraint-maxlik-optimization).}

\item{mu}{mu response required in constraint-maxlik-optimization).}

\item{n}{number of parameters (required in constraint-maxlik-optimization).}

\item{npar}{number of parameters (required in constraint-maxlik-optimization).}

\item{genome_factor}{Genomic conversion factor used in translocations.}

\item{calc_type}{Calculation type, either "fitting" or "estimation".}
}
\value{
Data frame of model statistics.
}
\description{
Calculate model statistics
}
